#include "mbed.h"
#include <Pulse.h> //Library developed by Gustavo Ramirez;
#include "TextLCD.h"
 
TextLCD lcd(PTB18,PTB19,PTC0,PTC4,PTC6,PTC7, TextLCD::LCD16x2);
///           PIN4,PIN6,PIN11,PIN12,PIN13,PIN14
///            RS   E    D4    D5     D6    D7
/// PIN1 A TIERRA, PIN2 A VCC, PIN3 CON UNA R=1KOHMIO,PIN5 A TIERRA,PIN15 CON UNA R=1KOHMIO, PIN16 A VC
/// PIN 7 A PIN 10 NO SE LE CONECTA NADA.
PulseInOut irda(PTA1);// en este puerto se pone el sensor infrarrojo

int header =0; //Variable to store the header length
const int head_H = 9000*1.2; //+20% header length
const int head_L = 4500*0.8;//-20%  header length
int i=0;
int n=0;

float PeriodoPWM1=0.001;
float PeriodoLed=1.0;
float DC1=0.5;

const int pulso=562.5;//NEC uses 562.5µs pulse bursts;
const int num_bits = 32;//8 bits address - 8 bits address logical inverse -  8 bits data - 8 bits data logical inverse;
int num[num_bits];//Array to store logical 1 length;
int data_bin[num_bits]; //Array to store binary code transmited;
int address1; //variable to store the device address;
int address0; //variable to store the device address (inverse);
int data1; //variable to store the transmited data;
int data0; //variable to store the transmited data (inverse);
//motores
DigitalOut ade1(PTC1);//
DigitalOut atra1(PTC2);//
DigitalOut ade2(PTB3);//
DigitalOut atra2(PTB2);// 

/****Las teclas del control****/
const int adelante =96;
const int atras=97;
const int izquierda=101;
const int derecha =98;
const int pausa=104;

void imprimir_funcion(int dato)
{
    switch(dato) {
        case adelante:
            lcd.cls();
            lcd.locate(0,0);//0X,0Y
            lcd.printf("COMANDO!");
            lcd.locate(0,1);
            lcd.printf("adelante");
            ade1=1;
            atra1=0;
            ade2=1;
            atra2=0; 
            break;
        case atras:
            lcd.cls();
            lcd.locate(0,0);//0X,0Y
            lcd.printf("COMANDO!");
            lcd.locate(0,1);
            lcd.printf("atras");
            ade1=0;
            atra1=1;
            ade2=0;
            atra2=1;  
            break;
        case izquierda:
            lcd.cls();
            lcd.locate(0,0);//0X,0Y
            lcd.printf("COMANDO!");
            lcd.locate(0,1);
            lcd.printf("izquierda");
            ade1=1;
            atra1=0;
            ade2=0;
            atra2=1; 
            break;
        case derecha:
            lcd.cls();
            lcd.locate(0,0);//0X,0Y
            lcd.printf("COMANDO!");
            lcd.locate(0,1);
            lcd.printf("derecha");
            ade1=0;
            atra1=1;
            ade2=1;
            atra2=0; 
            break;
        case pausa:
            lcd.cls();
            lcd.locate(0,0);//0X,0Y
            lcd.printf("COMANDO!");
            lcd.locate(0,1);
            lcd.printf("pausa");
            ade1=0;
            atra1=0;
            ade2=0;
            atra2=0;
            break;
    }

}

int main()
{
        lcd.locate(0,0);//0X,0Y
        lcd.printf("Presiona tecla");
        lcd.locate(0,1);//0X,0Y
        lcd.printf("Esp_comando");
        
    while(1) {
        /********************Header detection************************/
ini1:
        header=0;
        header = irda.read_low_us();
        if (header > head_L && header < head_H){
         goto seguir;//verificar que este en la tolerancia +-20%
        }else{
             goto ini1;
        }     
seguir:
        //leo los datos y se meten a un arreglo
        wait_us(4500/2);
        for(i=0; i<(num_bits); ++i) {
            num[i]=irda.read_high_us(); //Tiempos para estado siempre alto se almacenan en microsegundos
            wait_us(400);  //esperar una parte del estado bajo (562.5µs)
        }
        /*Imprimir en pantalla lo que obtengo*/
        for(i=0; i<(num_bits); ++i) {
            if(num[i]>pulso*1.2) {
                data_bin[i]=1;   //si la longitud es mayor que 1.2ms, representa un 1
            } else {
                data_bin[i]=0;   //si la longitud es más corta, representa un 0

            }

        }
        address1=0;
        for(i=0; i<8; i++) {
            address1=address1 + data_bin[i]*pow(2.0,i*1.0);
        }
        address0=0;
        for(i=8; i<16; i++) {
            address0=address0 + data_bin[i]*pow(2.0,(i-8)*1.0);
        }

        data1=0;
        for(i=16; i<24; i++) {
            data1=data1 + data_bin[i]*pow(2.0,(i-16.0)*1.0);
        }
        
        data0=0;
        for(i=24; i<32; i++) {
            data0=data0 + data_bin[i]*pow(2.0,(i-24)*1.0);
        }
        imprimir_funcion(data1);


    }
}