/*
 * Written by Zimin Wang
 *  
 */
#ifndef GPIO_INTERRUPT_H_
#define GPIO_INTERRUPT_H_

#include <InterruptIn.h>

// enable and disable interrupt from GPIO
extern void enable_GPIO_intr(void (*handler)(void));
extern void disable_GPIO_intr(void);

// GPIO_out should be put in main loop. When an output request interrupt from chip occurs,
// this function read output data from chip and print data. Then it sends an output acknowledge
// signal to unblock task in the chip. 
// When there is no output request interrupt it returns quietly.
extern void listen_req(void const *args);

// GPIO_in should be put in main loop. When an input request interrupt from chip occurs,
// this functino read user input and write user input to the chip. Then it sends an input
// acknowledge interrupt to unblock task in the chip.
// When there is no input request interrupt it returns quietly.
//extern void GPIO_in(void const *args);

#endif