#include "mbed.h"
#include "HX711.h"
#include "ST7567.h"
#define STEPS 100.0
#define MAX_WEIGHT 2.0

ST7567 lcd(P1_24, P1_20, P1_25, P1_22, P1_21); // mosi, sclk, reset, A0, nCS
Serial pc(USBTX,USBRX,115200);         
HX711 Balance(P3_25,P3_26);     
PwmOut ser_mtr(P2_3);

int main()
{
     float current_value;
     float initial_value;
     float weight;
     float i,j;
     lcd.set_contrast(0x3F);
     lcd.cls();
     lcd.locate(0, 1);
     lcd.printf("\n\n\n          Hello !");
     wait(2);
     lcd.cls();
     lcd.locate(0, 1);
     lcd.printf("\n\n\n    Calibtrating Sensors ..");
     ser_mtr.write(0.05f);
     wait(1);
     initial_value = Balance.getValue();
     ser_mtr.write(0.105f);
     wait(1);
     lcd.cls();
     
     while (true)
     {
        current_value = Balance.getValue();                                          
        weight = ((float)current_value-(float)initial_value)/315701; //Calibration - 315701 is the corresponding value for 1KG
        lcd.locate(4, 4);
        if (weight < 0.005)
        weight = 0.00;         
        lcd.printf("\n\n\n     Weight %.3lf KG",weight);
        //pc.printf("current_value : %ld   Kilograms :%.3lf\n",current_value,weight);
        for(i=0, j=0.105; i<=MAX_WEIGHT; i=i+(MAX_WEIGHT/STEPS), j=j-(0.055/STEPS)) {
                if(weight >= i)
             ser_mtr.write(j);
            }  
     } 
}