#include "mbed.h"
/* Include arm_math.h mathematic functions */
#include "arm_math.h"
/* Include mbed-dsp libraries */
#include "arm_common_tables.h"
#include "arm_const_structs.h"
#include "math_helper.h"

/* FFT settings */
#define SAMPLES                 512             /* 256 real party and 256 imaginary parts */
#define FFT_SIZE                SAMPLES / 2     /* FFT size is always the same size as we have samples, so 256 in our case */
#define SEUIL                   0.4


/* Global variables */
float32_t Input[SAMPLES];
float32_t Output[FFT_SIZE];
bool      trig=0;

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
AnalogIn loudness(A6);
Ticker     timer;

float32_t tab_temp[8][4];
float32_t moyenne[4];

void sample(){
    trig=1;
}

int main() {
    float maxValue;            // Max FFT value is stored here
    uint32_t maxIndex;         // Index in Output array where max value is
    float maxv;
    pc.baud(115200);
    pc.printf("Starting FFT\r\n");
    
    for(int k = 0; k < 10; k++) {
        timer.attach_us(&sample,100); //100us 10KHz sampling rate
        for (int i = 0; i < SAMPLES; i += 2) {
            while (trig==0){}
            trig=0;
            Input[i] = loudness.read() ;
            Input[i + 1] = 0;               //Imaginary Part set to zero
        }
        timer.detach();
    
        // Init the Complex FFT module, intFlag = 0, doBitReverse = 1
        //NB using predefined arm_cfft_sR_f32_lenXXX, in this case XXX is 256
        arm_cfft_f32(&arm_cfft_sR_f32_len256, Input, 0, 1);
 
        // Complex Magniture Module put results into Output(Half size of the Input)
        arm_cmplx_mag_f32(Input, Output, FFT_SIZE);
        
        //Calculates maxValue and returns corresponding value
        arm_max_f32(Output, FFT_SIZE, &maxValue, &maxIndex);
 
        maxv = Output[1];
        int index = 0;
        for (int i= 1; i<FFT_SIZE ; i++){
            if (maxv < Output[i]){
                maxv = Output[i];
                index = i;
            }
        }
        pc.printf("Maximum is %f\r\n, index %d\r\n",maxv, index);
        
        /*for (int i = 1 ; i<FFT_SIZE ; i++){  
            pc.printf("output[%d] = %f\r\n", i, (Output[i]/maxValue));
        }*/
        
        for(int i = 0; i < 4; i++) {
            tab_temp[k][i] = Output[i+11]/maxv;
            pc.printf("tab_temp[%d][%i] = %f\r\n", k, i, tab_temp[k][i]);
        }
    }
    
    float32_t tmp_sum = 0;
    for(int i = 0; i < 4; i++) {
        
        tmp_sum += tab_temp[0][i] + tab_temp[1][i] + tab_temp[2][i] + tab_temp[3][i] + 
                   tab_temp[4][i] + tab_temp[5][i] + tab_temp[6][i] + tab_temp[7][i];
        moyenne[i] = tmp_sum/8;
        tmp_sum = 0;
    }
    
    for(int i = 0; i < 4; i++) {
        pc.printf("moyenne[%d] = %f\r\n", i, moyenne[i]);
    }
    
    bool queenIsPresent = false;
    for(int i = 0; i < 4; i++) {
        if(moyenne[i] > SEUIL) {
            queenIsPresent = true;
        }
    }
}
