#include "mbed.h"
#include "rtos.h"
#include "MPU9250.h"
#include "math.h"
#define SAMPLE_TIME 0.001

Thread thread1;

/*----Constantes a cambiar----*/
float kiz = 0.5;
float kpz = 0.2;

int periodoPwm = 500;   //us

int RMax = 140;
int LMax = 140;
int RMin = 10;
int LMin = 10;

float velGiroR = 0.6;  // 1 -detiene la rueda, 2-giro eje
float velGiroL = 0.6;  // 0.5 - 2.0

/*----Comunicacion Serial----*/
Serial pc(USBTX, USBRX);

/*----Comunicacion SPI IMu----*/
mpu9250_spi imu(p5,p6,p7,p8);
Timer t;

/*----Salida pwm motores----*/
PwmOut motorR(p22); 
PwmOut motorL(p21);

/*----Entrada Joystick----*/
AnalogIn ejeX(p16); 
AnalogIn ejeY(p20);

/*----Entrada encoders----*/
InterruptIn encoderR(p29); 
DigitalIn encoder2R(p30);
InterruptIn encoderL(p27);
DigitalIn encoder2L(p28);

/*----variables rpm y sentido----*/
volatile long ISRCounterR = 0;
volatile long ISRCounterL = 0;
volatile long counterR = 0;
volatile long counterL = 0;

/*----variables pi----*/
float V00R = 0;
float V00L = 0;
float V01R;
float V01L;
float VUR;
float VUL;
float referenciaR;
float referenciaL;

/*----variables imu----*/
int lastUpdate = 0, now = 0;
float GyroMeasError = PI * (60.0f / 180.0f);     // gyroscope measurement error in rads/s (start at 60 deg/s), then reduce after ~10 s to 3
float beta = sqrt(3.0f / 4.0f) * GyroMeasError;  // compute beta


/*----funciones interrupcion----*/
void interruptR() {
    (encoderR.read() == encoder2R.read())?ISRCounterR++:ISRCounterR--;
}

void interruptL() {
    (encoderL.read() == encoder2L.read())?ISRCounterL++:ISRCounterL--;
}

void periodicFcns()
{
    imu.read_all(); //read all sensors
    //imu.MadgwickAHRSupdateIMU(imu.accelerometer_data[0], imu.accelerometer_data[1], imu.accelerometer_data[2], imu.gyroscope_data[0]*DegToRad, imu.gyroscope_data[1]*DegToRad, imu.gyroscope_data[2]*DegToRad,SAMPLE_TIME,beta);
    imu.MadgwickQuaternionUpdate( imu.accelerometer_data[0], imu.accelerometer_data[1], imu.accelerometer_data[2], imu.gyroscope_data[0]*DegToRad, imu.gyroscope_data[1]*DegToRad, imu.gyroscope_data[2]*DegToRad,  imu.Magnetometer[1],  imu.Magnetometer[0], imu.Magnetometer[2],SAMPLE_TIME,beta); //my,mx,mz
}

float map(float x, float in_min, float in_max, float out_min, float out_max){
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

void control_pi_thread() {
    while (true) {
        float refY = ejeY.read();
        float refX = ejeX.read();
        refY = map(refY, 0.5, 0.93, 0, RMax);                  
        refX = map(refX, 0.12, 1.00, -1.0, 1.0);
        
        if(refX > 0){
            referenciaR = refY - refX * (refY*velGiroR);
            referenciaL = refY;

        } else{
            referenciaR = refY;
            referenciaL = refY + refX * (refY*velGiroL);
        }

        if(referenciaR > 0 && referenciaR < RMin){
            referenciaR = 0;
        }
        if(referenciaL > 0 && referenciaR < RMin){
            referenciaL = 0;
        }


        float errorR = referenciaR - counterR;
        float errorL = referenciaL - counterL;

        V01R = V00R + kiz*errorR;
        V01L = V00L + kiz*errorL;
        VUR = V01R + kpz*errorR;
        VUL = V01L + kpz*errorL;

        if(VUR > periodoPwm){
            VUR = periodoPwm;
        } else if(VUR < 10){
            VUR = 0;   
        } else{
            V00R = V01R;
        }
        if(VUL > periodoPwm){
            VUL = periodoPwm;
        } else if(VUL < 10){
            VUL = 0;   
        } else{
            V00L = V01L;
        }

        motorR.pulsewidth_us(VUR);
        motorL.pulsewidth_us(VUL);

        Thread::wait(50);
    }
}


/*----Loop Principal----*/
int main(){
    pc.baud(9600);
    pc.printf("Inicio Programa");

    /*----calibracion IMU----*/
    imu.calibrateMPU9250();
    if(imu.init(1,BITS_DLPF_CFG_188HZ)) {
        pc.printf("\nCouldn't initialize MPU9250 via SPI!");
    }
    pc.printf("\r\n\n\n______________________________________________________\r\n");
    pc.printf("\n\rWHOAMI=0x%2x",imu.whoami());
    pc.printf("\n\rGyro_scale=%u",imu.set_gyro_scale(BITS_FS_2000DPS));
    pc.printf("\n\rAcc_scale=%u",imu.set_acc_scale(BITS_FS_16G));
    pc.printf("\n\rAK8963=0x%2x",imu.AK8963_whoami());
    imu.AK8963_calib_Magnetometer();
    wait(1);
    
    /*----se activan las interrupciones----*/
    encoderR.rise(&interruptR);
    encoderL.rise(&interruptL); 
    
    /*----periodo de pwm----*/
    motorR.period_us(periodoPwm); 
    motorL.period_us(periodoPwm);

    t.start();
    Ticker doControl;
    doControl.attach(&periodicFcns, SAMPLE_TIME);

    thread1.start(control_pi_thread); 
    
    while (1) {

        /*----medicion velocidad----*/

        ISRCounterL = 0;
        ISRCounterR = 0; 
        encoderL.enable_irq(); 
        encoderR.enable_irq();
        wait_ms(150);
        encoderL.disable_irq();
        encoderR.enable_irq();
        counterR = ISRCounterR;
        counterL = ISRCounterL;

        now=t.read_ms();
        if (now-lastUpdate>=100) {
            lastUpdate=now;
            pc.printf("%5.2f,%5.2f,%5.2f\r\n",
                imu.euler_angle(0),imu.euler_angle(1),imu.euler_angle(2));// 0=roll, 1=pitch, 2=yaw
        }
        if(now > 10000) {
            //beta== sqrt(3.0f / 4.0f) * PI * (40.0f / 180.0f);
            beta = 0.04;  // decrease filter gain after stabilized
            t.reset();
            now = 0;
            lastUpdate=0;
        }

        pc.printf("R %3.0f", referenciaL);              /*          -----*/
        pc.printf(":%3.0f \r\n", referenciaR);

        pc.printf("C %3d", counterL);                       /*          -----*/
        pc.printf(":%3d \r\n", counterR);        
        pc.printf("\n");
    }
}
