#include "mbed.h"

#define XBEE_SERVER         0
#define XBEE_CLIENT         1
#define SERIAL_BAUDRATE     115200
#define BUFFER_SIZE         14
#define BUFFER_FORMAT       "%X %X %X %X %X %X %X %X %X"
#define BUFFER_FORMAT_RX    "%c%c%c%c%c%c%c%c%c%c%c%c"
#define BUFFER_RX_DATA_WR   &CommandRx[0],&CommandRx[1],&CommandRx[2],&CommandRx[3],\
                            &CommandRx[4],&CommandRx[5],&CommandRx[6],&CommandRx[7],\
                            &CommandRx[8],&CommandRx[9],&CommandRx[10],&CommandRx[11]
#define BUFFER_RX_DATA_RD   CommandRx[0],CommandRx[1],CommandRx[2],CommandRx[3],\
                            CommandRx[4],CommandRx[5],CommandRx[6],CommandRx[7],\
                            CommandRx[8]

Serial PC(USBTX, USBRX);
DigitalOut Indicator(LED_GREEN);
int XBee_u16Loop;

#if XBEE_SERVER == 1
Serial XBeeServer(PTC17, PTC16); /* Tx, Rx*/
char CommandTx[BUFFER_SIZE]={0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, '\0'};
DigitalOut RSTServer(PTB9);
int XBee_u16TxResult;
int XBee_u8TxRq;
#endif

#if XBEE_CLIENT == 1
Serial XBeeClient(PTE24, PTE25); /* Tx, Rx*/
DigitalOut RSTClient(PTA1);
char CommandRx[BUFFER_SIZE];
volatile int XBee_u8RxResult;
int XBee_boRxIndication = 0;
int XBee_boRxAllowed = 1;

/* This function is called when a character goes into the RX buffer.*/
void XBeeClientRx() 
{
    int hits = 0;
    char cStartOfFrame[1];
    memset(CommandRx,0,BUFFER_SIZE);
    if(XBee_boRxAllowed == 1)
    {
        XBee_boRxIndication = 0;
        while(1)
        {
            cStartOfFrame[0] = XBeeClient.getc();
            if(cStartOfFrame[0]==0x55)
            {
                hits++;
            }
            if(hits==2)
            {
                break;
            }
        }
        if(hits==2)
        {
            XBee_u8RxResult = 0;
            XBee_u8RxResult = XBeeClient.scanf( BUFFER_FORMAT_RX, BUFFER_RX_DATA_WR );
            if(XBee_u8RxResult>0)
            {
                if(CommandRx[BUFFER_SIZE-5]==0xAA && CommandRx[BUFFER_SIZE-4]==0xAA)
                {
                    /* next BUFFER_SIZE - 5 chars are the payload */
                    XBee_boRxIndication = 1;   
                }
            }
        }
         
        if(XBee_boRxIndication == 1)
        {
            PC.printf("\r\nRx done [%i]. ",XBee_u8RxResult);
            PC.printf( BUFFER_FORMAT, BUFFER_RX_DATA_RD );
        }
    }
    return;
}
#endif

void XBee_vInit(void)
{ 
    XBee_u16Loop = 0;
    
    PC.baud(SERIAL_BAUDRATE);
    
    #if XBEE_SERVER == 1
    PC.printf("\r\nSetting server XBee...");
    XBeeServer.baud(SERIAL_BAUDRATE); 
    XBee_u16TxResult = 0; 
    XBee_u8TxRq = 0;  
    #endif
    
    #if XBEE_CLIENT == 1
    PC.printf("\r\nSetting client XBee...");
    XBeeClient.baud(SERIAL_BAUDRATE);   
    XBeeClient.attach(&XBeeClientRx, Serial::RxIrq);
    XBee_u8RxResult = 0;
    XBee_boRxAllowed = 1;
    #endif    
    
    /* XBee reset*/
    #if XBEE_SERVER == 1
    RSTServer = 0;
    #endif
    #if XBEE_CLIENT == 1
    RSTClient = 0;
    #endif   
    wait_ms(1);
    #if XBEE_SERVER == 1
    RSTServer = 1;
    #endif
    #if XBEE_CLIENT == 1
    RSTClient = 1;
    #endif   
    wait_ms(1);
}

#if XBEE_SERVER == 1
void XBee_vMain(void)
{
    XBee_u16Loop++;
    PC.printf("\r\n[%i]:",XBee_u16Loop);   
    
    if(XBee_u8TxRq == 1)
    {
        /* a Tx job request is active */
        PC.printf("\r\nTx... ");
        #if XBEE_CLIENT == 1
        /* disable rx */
        XBee_boRxAllowed = 0;
        #endif
        for (int i=0; i<BUFFER_SIZE; i++) 
        {
            while (true) 
            {
                if (XBeeServer.writeable()) 
                {
                    XBee_u16TxResult= XBeeServer.putc(CommandTx[i]);
                    PC.printf("%X ", XBee_u16TxResult);
                    break;
                }
            }
        }
        /* tx done */
        PC.printf("\r\nTx done. ");
        XBee_u8TxRq = 0;
        #if XBEE_CLIENT == 1
        /* enable rx */
        XBee_boRxAllowed = 1;
        #endif
    } 
}
#endif /*#if XBEE_SERVER == 1*/

#if 1

int main()
{
    #if XBEE_SERVER == 1
    char TxJob[BUFFER_SIZE] = {0x55, 0x55, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0xAA, 0xAA, '\0'};    
    #endif
    
    XBee_vInit();
    
    while (true) {
        wait(0.2f); // wait a small period of time
        Indicator = !Indicator; // toggle a led
        
        #if XBEE_SERVER == 1
        XBee_vMain();  
        memcpy(CommandTx,TxJob,BUFFER_SIZE);
        XBee_u8TxRq = 1;
                
        for(int i=0;i<BUFFER_SIZE-1;i++)
        {
            TxJob[i]++;
        }
        #endif
        
    }
}
#endif

