#ifndef ITG3205_H
#define ITG3205_H

#include "mbed.h"

#define ITG3205_ADDR       0x68
#define ITG3205_WHO_AM_I   0x00
#define ITG3205_SMPLRT     0x15
#define ITG3205_DLPFS      0x16
#define ITG3205_INT_CFG    0x17
#define ITG3205_INT_STATUS 0x1A
#define ITG3205_PWRM       0x3E

#define ITG3205_XMSB       0x1D
#define ITG3205_XLSB       0x1E
#define ITG3205_YMSB       0x1F
#define ITG3205_YLSB       0x20
#define ITG3205_ZMSB       0x21
#define ITG3205_ZLSB       0x22

class ITG3205 
{

public:

    ITG3205(PinName sda, PinName scl);
    void Write(char reg, char data);
    char Read(char data);
    bool isRawReady();
    float getGyroX(void);
    float getGyroY(void);
    float getGyroZ(void);
private:
    I2C i2c;
};

#endif /* ITG3205_H */
