#ifndef GYROSCOPE_H
#define GYROSCOPE_H

#include "ITG3205.h"

#define PI  3.14159265

class Gyroscope
{
    public:
        Gyroscope(ITG3205* gyroHardware, float sensitivity, float dataRate);
        ~Gyroscope(void);
        
        void updateZeroRates();
        
        void update();
        void update(int samplesSize, int sampleDataRate);
        
        void resetAngles();
        
        float getRadiansX();
        float getRadiansY();
        float getRadiansZ();
        
        float getDegreesX();
        float getDegreesY();
        float getDegreesZ();
        
        float getAngleX();
        float getAngleY();
        float getAngleZ();
    
    private:
        ITG3205* gyroHardware;
    
        float sensitivity;
        float dataRate;
        
        float zeroRateX, zeroRateY, zeroRateZ;
        
        float rawX;
        float rawY;
        float rawZ;
        
        float angleX;
        float angleY;
        float angleZ;
};

#endif /* GYROSCOPE_H */
