#include "mbed.h"
#include "ITG3205.h"
#include "Gyroscope.h"

#define SDA      p9
#define SCL      p10

ITG3205 *itg3205;
Gyroscope *gyroscope;
Serial pc(USBTX, USBRX);

float gyroX, gyroY, AngleX, AngleY;
Ticker updater;

void update()
{
    pc.printf("x: %f \t\t y: %f \t\t angle x: %f \t\t angle y: %f  \r\n", gyroX, gyroY, AngleX, AngleY);
}
int main()
{
    itg3205 = new ITG3205(SDA, SCL);
    gyroscope = new Gyroscope(itg3205, 14.375, 0.005);
    wait(1);
    gyroscope->updateZeroRates();
    pc.baud(115200);
    updater.attach(&update, 0.2);
    while(1) 
    {

        wait_ms(5);
        gyroscope->update();
        
        gyroX = gyroscope->getDegreesX();
        gyroY = gyroscope->getDegreesY() * -1;
        AngleX = gyroscope->getAngleX();
        AngleY = gyroscope->getAngleY();

        //printf("x: %f \t\t y: %f \t\t angle x: %f \t\t angle y: %f  \r\n", gyroX, gyroY, AngleX, AngleY);
        //printf("%f,%f,%f,%f\n", gyroX, gyroY, AngleX, AngleY);
        
    }

}
