#ifndef MBED_BMA180_H
#define MBED_BMA180_H

#define BMA180_WHO_AM_I 0x00
#define BMA180_ID       0x03
#define BMA180_ADDR     0x80 //datasheet says 0x40 !
#define BMA180_XLSB     0x02 //LSB
#define BMA180_XMSB     0x03 //MSB

#define BMA180_YLSB     0x04 //LSB
#define BMA180_YMSB     0x05 //MSB

#define BMA180_ZLSB     0x06 //LSB
#define BMA180_ZMSB     0x07 //MSB

#define BM180_CTRLREG0  0x0D
#define BM180_BWTCS     0x20
#define BMA180_OLSB1    0x35

#include "mbed.h"

class BMA180 {
public:
    BMA180(PinName sda, PinName scl);
    
    float getX();
    float getY();
    float getZ();
    void getOutput(int* readings);  
private:
    void Write(char reg, char data);
    char Read(char);
    void MultiByteRead(char address, char* output, int size); 
    I2C i2c;
    int16_t x,y,z;
};

#endif
