#include "mbed.h"
#include "BMA180.h"
/* Range em default value: 2g (010) / Resolução do ADC 0.25mg/LSB sensibilidade 4096 (LSBadc/g)
 * Range Register: 0x35 
 * Valor Range Resolução ADC (mg/LSB)                                              =================================
 * 000    1g     0.13                                                              || Prestar atenção nas unidades||
 * 001  1.5g     0.19                                                              =================================
 * 010    2g     0.25
 * 011    3g     0.38
 * 100    4g     0.50
 * 101    8g     0.99
 * 110   16g     1.98
 */
BMA180::BMA180(PinName sda, PinName scl): i2c(sda, scl)
{
    char rx, temp1, temp2;
    i2c.frequency(100000);
    //Testar depois com 400KHz
    //==========================================================================================================
    // Read chip_id
    //==========================================================================================================
    rx = Read(BMA180_WHO_AM_I);
    if (rx != BMA180_ID)//ID do chip 
        printf("\ninvalid chip id %d\r\n", rx);
    //==========================================================================================================
    // Set CTRLREG0 0x0D, bit ee_w (0001 0000) to update image and make it possible write in to the chip eeprom
    //==========================================================================================================
    rx = Read(BM180_CTRLREG0);
    rx |= 0x10;   
    Write(BM180_CTRLREG0, rx);    
    //Let's confirm
    rx = Read(BM180_CTRLREG0);
    temp1 = rx | 0x10;
    if(rx != temp1)
        printf("\nee_w bit wasn't changed %d\r\n", rx);  
    // ee_w bit set, OK
    //==========================================================================================================
    // Let's define the low-pass filter's bandwidth to 10Hz (bw<3:0> -> 0000), to reduce noise in the signal
    // To set the bw bit, we will have to acces the bw_tcs register (0x20) 
    //==========================================================================================================
    rx = Read(BM180_BWTCS);
                                                   // procedure: readed value: i.e 0101 0101     
    temp1 = 0x00;                                  //                        (AND) 0000 1111 -> (~BWMask)
    temp1 = temp1 << 4;                            //                              ---------
    rx &= (~0xF0); //Mask                          //                        (OR)  0000 0101
    rx |= temp1;                                   //              Wanted Value <-[0000]0000 -> Wanted value with 4's complement
    Write(BM180_BWTCS, rx);                        //                              --------- 
    //Let's confirm                                //                              0000 0101 -> Final Value
    rx = Read(BM180_BWTCS);
    temp2 = rx;
    temp1 = 0x00;
    temp1 = temp1 << 4;
    temp2 &= (~0xF0); //Mask
    temp2 |= temp1;
    if(rx != temp2)
        printf("\nbw bit wasn't changed %d\r\n", rx);  
    // low-pass filter's bandwidth defined, OK
    
    //==========================================================================================================
    // Let's set the range to 2g (0x02) in the 
    //==========================================================================================================
    rx = Read(BMA180_OLSB1);                       // procedure: value to set with 1's complement 0000 [010]0
    temp1 = 0x02;                                  //            readed value: i.e 0101 0101 
    temp1 = temp1 << 1;                            //                        (AND) 1111 0001 -> RangeMask
    rx &= (~0x0E);                                 //                              ---------
    rx |= temp1;                                   //                              0101 0001
    Write(BMA180_OLSB1, rx);                        //                         (OR) 0000 0100 -> Shifted value
    // Let's confirm                               //                              ---------
    rx = Read(BMA180_OLSB1);                       //                              0101 0101 -> Final Value
    temp2 = rx;
    temp1 = 0x02;
    temp1 = temp1 << 1;
    temp2 &= (~0x0E);
    temp2 |= temp1;
    if(rx != temp2)
        printf("\nRange not set %d\r\n", rx); 
}

void BMA180::Write(char reg, char data)
{
    char c_data[2];
    c_data[0] = reg;
    c_data[1] = data;
    i2c.write(BMA180_ADDR, c_data, 2);
}

char BMA180::Read(char data)
{       
    char tx = data;
    char rx;
    
    i2c.write((BMA180_ADDR) & 0xFE, &tx, 1); // 0xFE ensure that the MSB bit is being set to zero (RW=0 -> Writing)
    i2c.read((BMA180_ADDR) | 0x01, &rx, 1);  // 0x01 ensure that the MSB bit is being set to one  (RW=1 -> Reading)
                                             // The read/write method of I2C does this automatically, so it's useless to set manually                                           
    return rx;
}

void BMA180::MultiByteRead(char address, char* output, int size) 
{
    i2c.write( (BMA180_ADDR) & 0xFE, &address, 1);      //tell it where to read from
    i2c.read( (BMA180_ADDR) | 0x01 , output, size);     //tell it where to store the data read
}

float BMA180::getX()
{
    char lsb_byte = 0;
    signed short msb_byte;
    float acc;
    
    while (lsb_byte != 1)
    {
        lsb_byte = Read(BMA180_XLSB) & 0x01;
    }
        
    lsb_byte = Read(BMA180_XMSB);
    msb_byte = lsb_byte << 8;
    msb_byte |= Read(BMA180_XLSB);
    msb_byte = msb_byte >> 2; // Get rid of two non-value bits in LSB
    //printf("%d \t", msb_byte);
    acc = (float)msb_byte;
    return acc;
}

float BMA180::getY()
{
    char lsb_byte = 0;
    signed short msb_byte;
    float acc;
    
    while (lsb_byte != 1)
    {
        lsb_byte = Read(BMA180_YLSB) & 0x01;
    }
        
    lsb_byte = Read(BMA180_YMSB);
    msb_byte = lsb_byte << 8;
    msb_byte |= Read(BMA180_YLSB);
    msb_byte = msb_byte >> 2; // Get rid of two non-value bits in LSB
    //printf("%d \t", msb_byte);
    acc = (float)msb_byte;
    return acc;
}

float BMA180::getZ()
{
    char lsb_byte = 0;
    signed short msb_byte;
    float acc;
    
    while (lsb_byte != 1)
    {
        lsb_byte = Read(BMA180_ZLSB) & 0x01;
    }
        
    lsb_byte = Read(BMA180_ZMSB);
    msb_byte = lsb_byte << 8;
    msb_byte |= Read(BMA180_ZLSB);
    msb_byte = msb_byte >> 2; // Get rid of two non-value bits in LSB
    //printf("%d \t", msb_byte);
    acc = (float)msb_byte;
    return acc;
}

void BMA180::getOutput(int* readings)
{
    char buffer[6];    
    MultiByteRead(BMA180_XLSB, buffer, 6);
    
    readings[0] = (int)buffer[1] << 8 | (int)buffer[0];
    readings[1] = (int)buffer[3] << 8 | (int)buffer[2];
    readings[2] = (int)buffer[5] << 8 | (int)buffer[4];

}