#ifndef ACCELEROMETER_H
#define ACCELEROMETER_H

#include <math.h>

#include "BMA180.h"

class Accelerometer
{
    public:
        Accelerometer(BMA180* acceleHardware, float sensitivity);
        ~Accelerometer(void);
        
        void updateZeroRates();
        
        void update();
        void update(int samplesSize, int sampleDataRate);
        
        float getAccelerationX();
        float getAccelerationY();
        float getAccelerationZ();
        
        float getRadiansAngleX();
        float getRadiansAngleY();
        
        float getDegreesAngleX();
        float getDegreesAngleY();
        
        static float getPI();
    
    private:
        BMA180* acceleHardware;
        
        float sensitivity;        
        float zeroRateX, zeroRateY, zeroRateZ;
        
        float rawX;
        float rawY;
        float rawZ;
};

#endif
