
#include "L3G4200D.h"

L3G4200D::L3G4200D(PinName mosi, PinName miso, PinName sck, PinName cs) : _spi(mosi, miso, sck), _ncs (cs)
{
    _spi.frequency(2000000);
    _spi.format(8,3);
    _ncs = 1;
    wait_us(500);
    
    oneByteWrite(L3G4200D_SPI_WRITE | (CTRL_REG1), 0x6F);//-> Digital output data rate(ODR)=200Hz and Cut-Off 50Hz
    oneByteWrite(L3G4200D_SPI_WRITE | (CTRL_REG2), 0x00);
    oneByteWrite(L3G4200D_SPI_WRITE | (CTRL_REG3), 0x00);
    oneByteWrite(L3G4200D_SPI_WRITE | (CTRL_REG4), 0x10); // Full Scale selection = 500 dps
    oneByteWrite(L3G4200D_SPI_WRITE | (CTRL_REG5), 0x00);
    
    wait_us(500);
}

void L3G4200D::setPowerMode(char mode)
{
}

int L3G4200D::getWhoAmI()
{
    return oneByteRead(L3G4200D_SPI_READ | (WHO_AM_I & 0x3F));
}

char L3G4200D::getTemperature()
{
    return (char)oneByteRead(L3G4200D_SPI_READ | (OUT_TEMP & 0x3F));
}

void L3G4200D::getAxes(int* axes)
{
    getData(axes, 3);
}

int L3G4200D::getAxisX()
{
    int axes[3];
    
    getData(axes, 3);
    
    return axes[0];
}

int L3G4200D::getAxisY()
{
    int axes[3];
    
    getData(axes, 3);
    
    return axes[1];
}

int L3G4200D::getAxisZ()
{
    int axes[3];
    
    getData(axes, 3);
    
    return axes[2];
}

void L3G4200D::getData(int* dataVector, int vectorSize)
{
    char* buffer = new char[vectorSize * 2];
    
    multiByteRead(L3G4200D_SPI_READ | L3G4200D_SPI_MULTI | (OUT_X_L & 0x3F), buffer, vectorSize * 2);
    
    for(int i = 0, j = 0; i < vectorSize; i++, j += 2)
    {
        dataVector[i] = (int16_t)((int)buffer[j+1] << 8 | (int)buffer[j]);
    }
    
    free(buffer);
}

float L3G4200D::getX()
{
    signed short byte = 0;    
    byte = (oneByteRead(OUT_X_H)&0xFF)<<8;
    byte |= (oneByteRead(OUT_X_L)&0xFF);
    return (float)byte;
}

float L3G4200D::getY()
{
    signed short byte = 0;    
    byte = (oneByteRead(OUT_Y_H)&0xFF)<<8;
    byte |= (oneByteRead(OUT_Y_L)&0xFF);
    return (float)byte;
}

float L3G4200D::getZ()
{
    signed short byte = 0;    
    byte = (oneByteRead(OUT_Z_H)&0xFF)<<8;
    byte |= (oneByteRead(OUT_Z_L)&0xFF);
    return (float)byte;
}


int L3G4200D::oneByteRead(int address) {
 
    int tx = (L3G4200D_SPI_READ | (address & 0x3F));
    int rx = 0;
 
    _ncs = 0;
    //Send address to read from.
    _spi.write(tx);
    //Read back contents of address.
    rx = _spi.write(0x00);
    _ncs = 1;
 
    return rx;
 
}
 
void L3G4200D::oneByteWrite(int address, char data) {
 
    int tx = (L3G4200D_SPI_WRITE | (address & 0x3F));
 
    _ncs = 0;
    //Send address to write to.
    _spi.write(tx);
    //Send data to be written.
    _spi.write(data);
    _ncs = 1;
 
}
 
void L3G4200D::multiByteRead(int startAddress, char* buffer, int size) {
 
    int tx = (L3G4200D_SPI_READ | L3G4200D_SPI_MULTI | (startAddress & 0x3F));
 
    _ncs = 0;
    //Send address to start reading from.
    _spi.write(tx);
 
    for (int i = 0; i < size; i++) {
        buffer[i] = _spi.write(0x00);
    }
 
    _ncs = 1;
 
}
 
void L3G4200D::multiByteWrite(int startAddress, char* buffer, int size) {
 
    int tx = (L3G4200D_SPI_WRITE | L3G4200D_SPI_MULTI | (startAddress & 0x3F));
 
    _ncs = 0;
    //Send address to start reading from.
    _spi.write(tx);
 
    for (int i = 0; i < size; i++) {
        buffer[i] = _spi.write(0x00);
    }
 
    _ncs = 1;
 
}
