#include "Motor.h"

Motor::Motor(PinName pwm, float _period/*, float* linCoef, float lowerSat, float upperSat*/) : PwmOut(pwm)
{    
    //period(_period);
    period_us(_period);
    
    currentPower = 0;
    
    //setPower(currentPower);
    
    //this->linCoef = linCoef;
    
    //this->lowerSat = lowerSat;
    //this->upperSat = upperSat;
}

/*Motor::Motor(PinName pwm, float periodms) : PwmOut(pwm)
{
    //Motor(pwm, (periodms*1000), new float[1], 0, 100);
    period_ms(periodms);
    
    //currentPower = 0;
    
    //this->linCoef = new float[1];
    
    //this->lowerSat = 0;
    //this->upperSat = 100;
}*/

void Motor::setPower(float power)
{
    power = clampFloat(power, 0.0, 100.0);
    
    //pulsewidth(PWM_MIN + (power / 100.0) * PWM_DT);
    write( (100-(PWM_MIN + power))/100);
    currentPower = power;
}

void Motor::setPowerLin(float power)
{
    setPower(power);
    /*
    float pwm = 0;
    
    power = clampFloat(power, 0.0, 100.0);
    
    for (int i = 0; i < 5; i++)
    {
        pwm += linCoef[4-i] * pow(power/100.0, i);
    }
    
    setPower(lowerSat + pwm*(upperSat - lowerSat));
    */
}
void Motor::arm(int pwm_ms)
{
    pulsewidth_ms(pwm_ms);
    //write( (power)/100 );
}
void Motor::accumulatePower(float accPower)
{
    setPower(currentPower + accPower);
}

float Motor::getPower()
{
    return currentPower;
}
