#include "MembershipFunction.h"

MembershipFunction::MembershipFunction(mfType type, float a, float b, float c, float d, float u, float v)
{
    this->type = type;
    
    this->a = a;
    this->b = b;
    this->c = c;
    this->d = d;
    
    this->u = u;
    this->v = v;
}

MembershipFunction::MembershipFunction(mfType type)
{
    this->type = type;
    
    a = 0;
    b = 0;
    c = 0;
    d = 0;
    
    u = 0;
    v = 0;

    //MembershipFunction(type, 0, 0, 0, 0, 0, 0);
}

MembershipFunction::~MembershipFunction(void)
{
}

float MembershipFunction::getValue(float x)
{
    switch (type)
    {
        case TRIMF:
            return trimf(x);
        break;

        case TRAPMF:
            return trapmf(x);
        break;
    }
    
    return 0;
}

void MembershipFunction::setValues(float a, float b, float c)
{
    this->a = a;
    this->b = b;
    this->c = c;
}

void MembershipFunction::setValues(float a, float b, float c, float d)
{
    this->a = a;
    this->b = b;
    this->c = c;
    this->d = d;
}

void MembershipFunction::setValues(float u, float v)
{
    this->u = u;
    this->v = v;
}

float MembershipFunction::trimf(float x)
{
    if (x <= a || x > c)
        return 0;

    if (x > a && x <= b)
        return (x - a) / (b - a);
    
    if (x > b && x <= c)
        return (c - x) / (c - b);
        
    return 0;
}

float MembershipFunction::trapmf(float x)
{
    if (x <= a || x > d)
        return 0;

    if (x > a && x <= b)
        return (x - a) / (b - a);

    if (x > b && x <= c)
        return 1;
    
    if (x > c && x <= d)
        return (d - x) / (d - c);
        
    return 0;
}

float MembershipFunction::centroid(float h)
{
    float p1, p2, at, bt, ct;

    switch (type)
    {
        case TRIMF:
            p1 = a + (b - a) * h;
            p2 = c - (c - b) * h;

            at = p2 - p1;
            bt = c - a;
            ct = p1 - a;

            return a + (2*at*ct + at*at + ct*bt + at*bt + bt*bt) / (3 * (at + bt));
            //return p1 + (p2 - p1) / 2.0;
        break;

        case TRAPMF:
            p1 = a + (b - a) * h;
            p2 = d - (d - c) * h;
            return p1 + (p2 - p1) / 2.0;
        break;
    }

    //return a + (c - a) / 2.0;
    return 0;
}
