#ifndef FUZZYIO_H
#define FUZZYIO_H

#pragma once

#include "MembershipFunction.h"

class FuzzyIO
{
    public:
        FuzzyIO(float rangeMin, float rangeMax);
        ~FuzzyIO(void);

        void addMF(MembershipFunction* mf);
        void addAutoMFs(int amount, mfType type);
        void addAutoMFs(int amount, mfType type, float rangeMin, float rangeMax);

        MembershipFunction* getMFs(int index);
        int getMFsLenght();
    
    private:
        //string inputName;
        
        float rangeMin;
        float rangeMax;
        
        MembershipFunction** mfs;
        int mfsLenght;
};

#endif
