#ifndef FC_H
#define FC_H

#pragma once

#include "FuzzyIO.h"

class FuzzyController
{
    public:
        FuzzyController(void);
        ~FuzzyController(void);

        void addInput(FuzzyIO* input);
        void addOutput(FuzzyIO* output);
        void addRules(int rulesAmount, int** mfsIndexs);

        float* compute(float* values);

    private:
        FuzzyIO** inputs;
        FuzzyIO** outputs;

        int inputsLenght;
        int outputsLenght;

        int rulesAmount;
        int** mfsIndexs;

        float* outputsValues;
        float* inputsValues;
        
        float* num;
        float* den;

        float min(float* values);
        float max(float* values);
};

#endif
