#ifndef L3G4200D_H
#define L3G4200D_H

#include "mbed.h"

// Enderecos dos registradores
#define WHO_AM_I        0x0F
#define CTRL_REG1        0x20
#define CTRL_REG2        0x21
#define CTRL_REG3        0x22
#define CTRL_REG4        0x23
#define CTRL_REG5        0x24
#define REFERENCE        0x25
#define OUT_TEMP        0x26
#define STATUS_REG        0x27
#define OUT_X_L            0x28
#define OUT_X_H            0x29
#define OUT_Y_L            0x2A
#define OUT_Y_H            0x2B
#define OUT_Z_L            0x2C
#define OUT_Z_H            0x2D
#define FIFO_CTRL_REG    0x2E
#define FIFO_SRC_REG    0x2F
#define INT1_CFG        0x30
#define INT1_SRC        0x31
#define INT1_TSH_XH        0x32
#define INT1_TSH_XL        0x33
#define INT1_TSH_YH        0x34
#define INT1_TSH_YL        0x35
#define INT1_TSH_ZH        0x36
#define INT1_TSH_ZL        0x37
#define INT1_DURATION    0x38

// Valores utilizados na comunicacao SPI para leitura e escrita
#define L3G4200D_SPI_READ     0x80
#define L3G4200D_SPI_WRITE    0x00
#define L3G4200D_SPI_MULTI    0x60

// Modos de operacoes
#define POWER_DOWN    0
#define SLEEP        1
#define NORMAL        2 

class L3G4200D
{
    public:
        L3G4200D(PinName mosi, PinName miso, PinName sck, PinName cs);
        
        void setPowerMode(char mode);
        
        int getWhoAmI();
        char getTemperature();
        
        void getAxes(int* axes);
        int getAxisX();
        int getAxisY();
        int getAxisZ();
        float getX();
        float getY();
        float getZ();
        
    private:
        virtual void getData(int* dataVector, int vectorSize);        
        SPI _spi;
        DigitalOut _ncs;

        int oneByteRead(int address);
        void oneByteWrite(int address, char data);
        void multiByteRead(int startAddress, char* buffer, int size);
        void multiByteWrite(int startAddress, char* buffer, int size);
        
};

#endif /* L3G4200D_H */
