#include "FuzzyController.h"

FuzzyController::FuzzyController(void)
{
    inputs = NULL;
    outputs = NULL;

    inputsLenght = 0;
    outputsLenght = 0;

    rulesAmount = 0;
    mfsIndexs = NULL;

    outputsValues = NULL;
}

FuzzyController::~FuzzyController(void)
{
}

void FuzzyController::addInput(FuzzyIO* input)
{
    inputs = (FuzzyIO**) realloc(inputs, sizeof(FuzzyIO*) * (inputsLenght + 1));
    
    inputs[inputsLenght] = input;
    
    inputsLenght++;
}

void FuzzyController::addOutput(FuzzyIO* output)
{
    outputs = (FuzzyIO**) realloc(outputs, sizeof(FuzzyIO*) * (outputsLenght + 1));
    
    outputs[outputsLenght] = output;
    
    outputsLenght++;
}

void FuzzyController::addRules(int rulesAmount, int** mfsIndexs)
{
    this->rulesAmount = rulesAmount;
    this->mfsIndexs = mfsIndexs;
}

float* FuzzyController::compute(float* values)
{
    if (outputsValues == NULL)
    {
        inputsValues = new float[inputsLenght];
        outputsValues = new float[outputsLenght];

        num = new float[outputsLenght];
        den = new float[outputsLenght];
    }

    for (int i = 0; i < outputsLenght; i++)
    {
        num[i] = 0;
        den[i] = 0;
    }

    for (int i = 0; i < rulesAmount; i++)
    {
        for (int j = 0; j < inputsLenght; j++)
        {
            inputsValues[j] = inputs[j]->getMFs(mfsIndexs[i][j])->getValue(values[j]);
        }
        
        float m = min(inputsValues);

        if (m == 0)
            continue;

        for (int j = 0; j < outputsLenght; j++)
        {
            num[j] += m * outputs[j]->getMFs(mfsIndexs[i][inputsLenght + j])->centroid(m);
            den[j] += m;
        }
    }

    for (int i = 0; i < outputsLenght; i++)
    {
        outputsValues[i] = num[i] / den[i];
    }

    return outputsValues;
}

float FuzzyController::min(float* values)
{
    float minValue = values[0];

    for (int i = 1; i < inputsLenght; i++)
    {
        if (values[i] < minValue)
            minValue = values[i];
    }

    return minValue;
}
