#include "Gyroscope.h"

Gyroscope::Gyroscope(L3G4200D* gyroHardware, float sensitivity, float dataRate)
{
    this->gyroHardware = gyroHardware;
    this->sensitivity = sensitivity;
    this->dataRate = dataRate;
    
    updateZeroRates();
}

Gyroscope::~Gyroscope(void)
{
}

void Gyroscope::updateZeroRates()
{
    update(100, 10, true);
    
    zeroRateX = rawX;
    zeroRateY = rawY;
    zeroRateZ = rawZ;
    
    resetAngles();
}

void Gyroscope::update()
{    
    update(1, 1, false);
}

void Gyroscope::update(int samplesSize, int sampleDataRate, bool iswait)
{
    int axes[3] = {0, 0, 0};
    
    rawX = 0;
    rawY = 0;
    rawZ = 0;
    
    for (int i = 0; i < samplesSize; i++)
    {
        gyroHardware->getAxes(axes);
        
       //O valor do ângulo real para o ângulo medido está com uma diferença de 2.4 vezes maior.
       rawX += ((gyroHardware->getX() * 2.55) / samplesSize);
       rawY += ((gyroHardware->getY() * 2.55) / samplesSize);
       rawZ += ((gyroHardware->getZ() * 2.55) / samplesSize);
        
        if(iswait)
            wait_ms(sampleDataRate);
    }
    
    angleX += getDegreesX() * dataRate;
    angleY += getDegreesY() * dataRate;
    angleZ += getDegreesZ() * dataRate;
}

void Gyroscope::resetAngles()
{
    angleX = 0;
    angleY = 0;
    angleZ = 0;
}

float Gyroscope::getDegreesX()
{
    return (rawX - zeroRateX) * sensitivity;
}

float Gyroscope::getDegreesY()
{
    return (rawY - zeroRateY) * sensitivity;
}

float Gyroscope::getDegreesZ()
{
    return (rawZ - zeroRateZ) * sensitivity;
}

float Gyroscope::getRadiansX()
{
    return getDegreesX() / 180.0 * PI;
}

float Gyroscope::getRadiansY()
{
    return getDegreesY() / 180.0 * PI;
}

float Gyroscope::getRadiansZ()
{
    return getDegreesZ() / 180.0 * PI;
}

float Gyroscope::getAngleX()
{
    return angleX;
}

float Gyroscope::getAngleY()
{
    return angleY;
}

float Gyroscope::getAngleZ()
{
    return angleZ;
}
