#ifndef ACCELEROMETER_H
#define ACCELEROMETER_H

#include <math.h>

#include "ADXL345.h"

class Accelerometer
{
    public:
        Accelerometer(ADXL345* acceleHardware, float sensitivity);
        ~Accelerometer(void);
        
        void updateZeroRates();
        
        void update();
        void update(int samplesSize, int sampleDataRate, bool iswait);
        
        float getAccelerationX();
        float getAccelerationY();
        float getAccelerationZ();
        
        float getRadiansAngleX();
        float getRadiansAngleY();
        
        float getDegreesAngleX();
        float getDegreesAngleY();
        
        static float getPI();
    
    private:
        ADXL345* acceleHardware;
        
        float sensitivity;        
        float zeroRateX, zeroRateY, zeroRateZ;
        
        float rawX;
        float rawY;
        float rawZ;
};

#endif
