
#include "Accelerometer.h"

Accelerometer::Accelerometer(ADXL345* acceleHardware, float sensitivity)
{
    this->acceleHardware = acceleHardware; 
    this->sensitivity = sensitivity;   
    updateZeroRates();
}

Accelerometer::~Accelerometer(void)
{
}

void Accelerometer::updateZeroRates()
{
    //update(253, 10); // Utilizando filtro passa baixa, é necessário 253 amostras para estabilização do filtro.
    update(200, 10, true);
    zeroRateX = rawX;
    zeroRateY = rawY;
    zeroRateZ = rawZ;
}

void Accelerometer::update()
{    
    update(1, 1, false);
}

void Accelerometer::update(int samplesSize, int sampleDataRate, bool iswait)
{   
    int axes[3] = {0, 0, 0};
    rawX = 0;
    rawY = 0;
    rawZ = 0;
    
    for (int i = 0; i < samplesSize; i++)
    {
        acceleHardware->getAxes(axes);
        //O valor do ângulo real para o ângulo medido está com uma diferença de 2.5 vezes maior.
        rawX += ((float)axes[0]) / samplesSize;
        rawY += ((float)axes[1]) / samplesSize;
        rawZ += ((float)axes[2]) / samplesSize;
        
        /*rawX += (acceleHardware->getX()) / samplesSize;
        rawY += (acceleHardware->getY()) / samplesSize;
        rawZ += (acceleHardware->getZ()) / samplesSize;*/
        
        if(wait)
            wait_ms(sampleDataRate);
    }
}

float Accelerometer::getAccelerationX()
{
    //( * Vref / 1023 – VzeroG) / Sensitivity
    //return (((rawX - zeroRateX) / sensitivity) + 1.0); //Devido a posição da plaquinha, quando se define o zeroRateX, tem que adicionar novamente a gravidade, que está influenciando o X
    return ((rawX - zeroRateX) / sensitivity);
}

float Accelerometer::getAccelerationY()
{
    return ((rawY - zeroRateY) / sensitivity);
}

float Accelerometer::getAccelerationZ()
{
    return (((rawZ - zeroRateZ) / sensitivity) + 1.0);
}

float Accelerometer::getRadiansAngleX()
{
    float x = getAccelerationX();
    float z = getAccelerationZ();
    
    return (((float)atan2(x, z)) * 2.2);
}

float Accelerometer::getRadiansAngleY()
{
    float y = getAccelerationY();
    float z = getAccelerationZ();
    return (((float)atan2(y, z)) * 2.2);
}

float Accelerometer::getDegreesAngleX()
{
    return (getRadiansAngleX() / Accelerometer::getPI()) * 180.0;
}

float Accelerometer::getDegreesAngleY()
{
    return (getRadiansAngleY() / Accelerometer::getPI()) * 180.0;
}

float Accelerometer::getPI()
{
    return 3.14159265;
}
