#ifndef KALMANFILTER_H
#define KALMANFILTER_H

#include <stdlib.h>
#include <math.h>

class KalmanFilter
{
    public:
        KalmanFilter();
        ~KalmanFilter(void);
        
        void reset();
        float update(float gyroRaw, float accelAngle);
        float getEstimatedData();
    
    private:
        float A[2][2];
        float B[2][1];
        float C[1][2];
        float Sz[1][1];
        float Sw[2][2];
        
        float xhat[2][1];
        float P[2][2];
        
        void matrix_multiply(float* A, float* B, int m, int p, int n, float* C);
        void matrix_addition(float* A, float* B, int m, int n, float* C);
        void matrix_subtraction(float* A, float* B, int m, int n, float* C);
        void matrix_transpose(float* A, int m, int n, float* C);
        int matrix_inversion(float* A, int n, float* AInverse);
};

#endif
