#ifndef MF_H
#define MF_H

#include <stdlib.h>

#define NULL    0

enum mfType {TRIMF, TRAPMF, GUASSMF};

class MembershipFunction
{
    public:
        MembershipFunction(mfType type, float a, float b, float c, float d, float u, float v);
        MembershipFunction(mfType type);
        virtual ~MembershipFunction(void);

        float getValue(float x);
        void setValues(float a, float b, float c);
        void setValues(float a, float b, float c, float d);
        void setValues(float u, float v);

        float centroid(float h);
    
    private:
        mfType type;
    
        float a, b, c, d;
        float u, v;
        
        float trimf(float x);
        float trapmf(float x);
        float guassmf(float x);
};

#endif
