#include "FuzzyIO.h"

FuzzyIO::FuzzyIO(float rangeMin, float rangeMax)
{
    this->rangeMin = rangeMin;
    this->rangeMax = rangeMax;

    mfs = NULL;
    mfsLenght = 0;
}

FuzzyIO::~FuzzyIO(void)
{
}

void FuzzyIO::addMF(MembershipFunction* mf)
{
    mfs = (MembershipFunction**) realloc(mfs, sizeof(MembershipFunction*) * (mfsLenght + 1));
    
    mfs[mfsLenght] = mf;
    
    mfsLenght++;
}

void FuzzyIO::addAutoMFs(int amount, mfType type, float rangeMin, float rangeMax)
{
    if (amount <= 1)
    {
        MembershipFunction* mf = new MembershipFunction(type);
        mf->setValues(rangeMin, (rangeMin - rangeMax) / 2, rangeMax);
        
        this->addMF(mf);
        
        return;
    }
    
    float rangeDt = (rangeMax - rangeMin) / (amount - 1);
    float startPoint = rangeMin - rangeDt;
    
    for (int i = 0; i < amount; i++)
    {
        MembershipFunction* mf = new MembershipFunction(type);
        mf->setValues(startPoint, startPoint + rangeDt, startPoint + rangeDt * 2);
        
        startPoint = startPoint + rangeDt;
        
        this->addMF(mf);
    }
}

void FuzzyIO::addAutoMFs(int amount, mfType type)
{
    this->addAutoMFs(amount, type, this->rangeMin, this->rangeMax);
}

MembershipFunction* FuzzyIO::getMFs(int index)
{
    return mfs[index];
}

int FuzzyIO::getMFsLenght()
{
    return this->mfsLenght;
}
