/******************************************************************************************************/
/* Note: The STM32F401 has default 3.3V ADC pins                                                      */
/* Note: The STM32F401 has default 12 bits ADC but it is normalized to 16 bits (2^16 -> 65536 values) */
/******************************************************************************************************/

#include "mbed.h"

AnalogIn analog_sensor(A0);                             // Create the analog pin object

int main()
{
    float voltage_value;
    
    while(1)
    {      
        voltage_value = 3.3*adc_value/65535;           // Read and convert to voltage the analog input value [0.0 to 3.3]
        printf("\n Analog Read: %f V", voltage_value); // Show the value
        wait_ms(1);                                    // Wait 1ms between reads for stability
    }
}