#ifndef MIDII_h
    #define MIDII_h
    
    #include "mbed.h"

    #define MIDI_VELOCITY 31250
  
    #define NOTE_OFF              0x8 // B1000
    #define NOTE_ON               0x9 // B1001
    #define NOTE_POLY_AFTERTOUCH  0xA // B1010
    #define NOTE_CONTROL_CHANGE   0xB // B1011
    #define NOTE_PROGRAM_CHANGE   0xC // B1100
    #define NOTE_AFTERTOUCH       0xD // B1101
    #define NOTE_PITCH_BEND       0xE // B1110
    #define NOTE_CONFIG           0xF // B1111
  
    #define CH_1                  0x0 // B0000
    #define CH_2                  0x1 // B0001
    #define CH_3                  0x2 // B0010
    #define CH_4                  0x3 // B0011
    #define CH_5                  0x4 // B0100
    #define CH_6                  0x5 // B0101
    #define CH_7                  0x6 // B0110
    #define CH_8                  0x7 // B0111
    #define CH_9                  0x8 // B1000
    #define CH_10                 0x9 // B1001
    #define CH_11                 0xA // B1010
    #define CH_12                 0xB // B1011
    #define CH_13                 0xC // B1100
    #define CH_14                 0xD // B1101
    #define CH_15                 0xE // B1110
    #define CH_16                 0xF // B1111
  
    #define C   0
    #define C_  1
    #define D   2
    #define D_  3
    #define E   4
    #define F   5
    #define F_  6
    #define G   7
    #define G_  8
    #define A   9
    #define A_  10
    #define B   11
  
    #define OCTAVE_0  0
    #define OCTAVE_1  1
    #define OCTAVE_2  2
    #define OCTAVE_3  3
    #define OCTAVE_4  4
    #define OCTAVE_5  5
    #define OCTAVE_6  6
    #define OCTAVE_7  7
    #define OCTAVE_8  8
    #define OCTAVE_9  9
    #define OCTAVE_10 10
  
    #define NUMBER 12
    #define OCTAVE 11

    /*
                        Note Numbers
    Octave       C       C#      D       D#       E      F       F#       G      G#      A       A#      B
        0        0       1       2       3        4      5       6        7      8       9       10      11
        1        12      13      14      15      16      17      18       19     20      21      22      23
        2        24      25      26      27      28      29      30       31     32      33      34      35
        3        36      37      38      39      40      41      42       43     44      45      46      47
        4        48      49      50      51      52      53      54       55     56      57      58      59
        5        60      61      62      63      64      65      66       67     68      69      70      71
        6        72      73      74      75      76      77      78       79     80      81      82      83
        7        84      85      86      87      88      89      90       91     92      93      94      95
        8        96      97      98      99      100     101     102     103     104     105     106     107
        9        108     109     110     111     112     113     114     115     116     117     118     119
        10       120     121     122     123     124     125     126     127
    */
    
    /*typedef int n[OCTAVE][NUMBER] = 
    {
        {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11},
        {12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23},
        {24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35},
        {36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47},
        {48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59},
        {60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71},
        {72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83},
        {84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95},
        {96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107},
        {108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119},
        {120, 121, 122, 123, 124, 125, 126, 127, 0, 0, 0, 0}
    }NOTES;*/

    class MIDII
    {
        public:
            MIDII(PinName p_tx, PinName p_rx);
            ~MIDII();
            void noteOn(unsigned int channel, unsigned int key, unsigned int octave, unsigned int velocity);
            void noteOff(unsigned int channel, unsigned int key, unsigned int octave, unsigned int velocity);
            void programChange(unsigned int channel, unsigned int program);
            void MIDImessage(unsigned int command, unsigned int channel, unsigned int note, unsigned int octave, unsigned int velocity);

        private:
            int note[OCTAVE][NUMBER];
            Serial serial;
          
            void notes_init();
    
    };
  
#endif