#include "midii.h"
#include "mbed.h"

MIDII::MIDII(PinName p_tx, PinName p_rx) : serial(p_tx, p_rx)
{
    serial.baud(MIDI_VELOCITY);
    notes_init();
}

MIDII::~MIDII()
{}
    
void MIDII::noteOn(unsigned int channel, unsigned int key, unsigned int octave, unsigned int velocity)
{
    if(channel > CH_16)
        channel = CH_16;
    if(velocity > 127)
        velocity = 127;
    if(octave > 10)
        octave = 10;
        
    serial.putc(NOTE_ON & channel);
    serial.putc(note[octave][key]);
    serial.putc(velocity);
}

void MIDII::noteOff(unsigned int channel, unsigned int key, unsigned int octave, unsigned int velocity)
{
    if(channel > CH_16)
        channel = CH_16;
    if(velocity > 127)
        velocity = 127;
        
    serial.putc(NOTE_OFF & channel);
    serial.putc(key);
    serial.putc(velocity);
}

void MIDII::programChange(unsigned int channel, unsigned int program)
{
    if(channel > CH_16)
        channel = CH_16;
        
    serial.putc(NOTE_PROGRAM_CHANGE & channel);
    serial.putc(program);
}

//send MIDI message
void MIDII::MIDImessage(unsigned int command, unsigned int channel, unsigned int note, unsigned int octave, unsigned int velocity)
{        
    serial.putc(command & channel);//send note on or note off command 
    serial.putc(note);//send pitch data
    serial.putc(velocity);//send velocity data
}

void MIDII::notes_init()
{
    int a, b, c;
    
    c = 0;
    for(a = 0; a < OCTAVE; a++)
    {
        for(b = 0; b < NUMBER; b++)
        {
            note[a][b] = c;
            c++;
        }
    }
}
