#include "mbed.h"
 
const long interval = 1000; // Time between blink (1s)
 
int main()
{
    Timer timer;                                      // Create the Timer object
    DigitalOut led(LED1, 0);                          // Create the LED object and setup OFF
    unsigned long currentMillis, previousMillis;      // Variables for time reading

    timer.start();                                    // Start the Timer
    previousMillis = timer.read_ms();                 // Read the actual time
    while(1)
    {
        currentMillis = timer.read_ms();              // Read the actual time
        if(currentMillis - previousMillis > interval) // Compare if the time between blink has success (interval == 1s)
        {
            led = !led;                               // Toggle the LED state
            previousMillis = currentMillis;           // Save the last time you toggle the LED 
        }
    }
}