#include "mbed.h"

DigitalOut led(LED1, 0);                    // Create the LED object and setup OFF
Timeout timeout;                            // Create the Timeout object

void wait_LowPow(unsigned long time);       // Wait in low power mode function prototype

void timer_interrupt()                      // The Timer interrupt service routine
{
                                            // Nothing to do, just for wakeup the system
}

int main()
{
    while(1)
    {
        led = 1;                            // Turn LED ON
        wait_LowPow(1);                     // Wait 1s in low power mode
        led = 0;                            // Turn LED OFF
        wait_LowPow(1);                     // Wait 1s in low power mode
    }
}

void wait_LowPow(unsigned long time)        // Wait in low power mode function implementation
{
    timeout.attach(&timer_interrupt, time); // Set the timer interrupt service rutine (ISR) and the time for the timeout (in seconds)
    sleep();                                // Enter Low Power Mode (It cant be used deep_sleep() mode, because that mode disable the timer)
}
