#include "mbed.h"

void beat(DigitalOut* led, double time); // Prototype of the function beat

int main()
{
    DigitalOut led(LED1, 0);            // Create the LED object and setup OFF
    
    while(1)
    {
        beat(&led, 1);                  // Beat the LED during 1s
    }
}

void beat(DigitalOut* led, double time)
{
    double portion = (0.33*time)/3;      // Calculate the third portion of the 33% of the time
    
    *led = 1;                           // LED ON
    wait(portion);                      // Wait a third portion of the 33% of the time
    *led = 0;                           // LED OFF
    wait(portion);                      // Wait a third portion of the 33% of the time
    *led = 1;                           // LED ON
    wait(portion);                      // Wait a third portion of the 33% of the time
    *led = 0;                           // LED OFF
    wait(time-(3*portion));             // Wait for the 66% of the time
}
