#include "mbed.h"

/***************************************/

#define INPUT 0
#define OUTPUT 1
#define INPUT_PULLUP 2
#define LOW 0
#define HIGH 1

/***************************************/

void setup();
void loop();
void pinMode(PinName pin, int mode);
void digitalWrite(PinName pin, int value);
int digitalRead(PinName pin);
void delay(unsigned long t);

/***************************************/

int main()
{
    setup();
    while(1)
    {
        loop();
    }
}

/***************************************/

// Type PinName is declared in mbed library
PinName button = USER_BUTTON; 
PinName led = LED1;

/***************************************/

void setup()
{
    pinMode(button, INPUT_PULLUP); // Set button as input with internall pull-up
    pinMode(led, OUTPUT);          // Set led as output
    digitalWrite(led, LOW);        // Set led off
}

void loop()
{
    // Basic digitalRead
    if(digitalRead(button) == LOW)
    {
        digitalWrite(led, HIGH);
        delay(200);
    }
    else
        digitalWrite(led, LOW);
        
    /*
    // Basic blink
    digitalWrite(led, HIGH);
    delay(1000);
    digitalWrite(led, LOW);
    delay(1000);
    */
}

/***************************************/

void pinMode(PinName pin, int mode)
{
    if(mode == INPUT)
        DigitalIn pm(pin);
    else if(mode == INPUT_PULLUP)
        DigitalIn pm(pin, PullUp);
    else if(mode == OUTPUT)
        DigitalOut pm(pin);
}

void digitalWrite(PinName pin, int value)
{
    DigitalOut dw(pin, value);
}

int digitalRead(PinName pin)
{
    DigitalIn dr(pin);
    
    return dr.read();
}

void delay(unsigned long t)
{
    wait_ms(t);
}
