#include "mbed.h"

#include "stm32f769i_discovery.h"
#include "stm32f769i_discovery_ts.h"
#include "stm32f769i_discovery_lcd.h"
#include "stm32f769i_discovery_audio.h"

#include <string>       // std::string
#include <iostream>     // std::cout, std::ostream, std::hex
#include <sstream>      // std::stringbuf
using namespace std;
TS_StateTypeDef  TS_State = {0};


Serial pc(USBTX, USBRX);
Serial uc(D1, D0);

DigitalOut led1(LED1);

void print_thread()
{
    while (true) {
        if(pc.readable()) {
            uc.putc(pc.getc());
        }
        if(uc.readable()) {
            pc.putc(uc.getc());
        }
    }
}

void led_thread() {
    while(true) {
        Thread::wait(200);
        led1 = !led1;
        pc.printf("Hallo LEDS\r\n");
    }
}

void gui_thread() {
    uint16_t x1, y1;
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(0, LCD_FB_START_ADDRESS);

    /* Touchscreen initialization */
    if (BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize()) == TS_ERROR) {
        printf("BSP_TS_Init error\n");
    }

    /* Clear the LCD */
    BSP_LCD_Clear(LCD_COLOR_WHITE);

    /* Set Touchscreen Demo1 description */
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    BSP_LCD_FillRect(0, 0, BSP_LCD_GetXSize(), 40);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetFont(&Font24);
    BSP_LCD_DisplayStringAt(0, 0, (uint8_t *)"Touchscreen basic example", CENTER_MODE);

    while (1) {
        BSP_TS_GetState(&TS_State);
        if(TS_State.touchDetected) {
            /* One or dual touch have been detected          */

            /* Get X and Y position of the first touch post calibrated */
            x1 = TS_State.touchX[0];
            y1 = TS_State.touchY[0];
            printf("Touch Detected x=%d y=%d\r\n", x1, y1);
            stringbuf touchstr;
             std::ostream os (&touchstr);     
            os << "Touch detected x=" << x1 << ", y"; // + y1;
            //string touchStr = 
            BSP_LCD_DisplayStringAt(0, 2, (uint8_t *) touchstr.str().c_str(), LEFT_MODE);
            //BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
            //BSP_LCD_FillCircle(x1, y1, 20);

            Thread::wait(10);
        }
    }
}



    const uint16_t BSIZE = 10000;
    uint16_t buf[BSIZE];




void audio_thread(Thread *thisThread)
{
    for(int i = 0; i < BSIZE; i++) {
      //  buf[i] = i*2;
    }
   /*  const uint32_t SCRATCH_BUFF_SIZE  = 128;
    const uint32_t RECORD_BUFFER_SIZE  = 512;

   typedef enum {
        BUFFER_OFFSET_NONE = 0,
        BUFFER_OFFSET_HALF = 1,
        BUFFER_OFFSET_FULL = 2,
    } BUFFER_StateTypeDef;
*/
    //olatile uint32_t  audio_rec_buffer_state = BUFFER_OFFSET_NONE;
    //int32_t Scratch[SCRATCH_BUFF_SIZE];
    /* Buffer containing the PCM samples coming from the microphone */
    //int16_t RecordBuffer[RECORD_BUFFER_SIZE];
    /* Buffer used to stream the recorded PCM samples towards the audio codec. */

   // uint32_t audio_loop_back_init = RESET ;

    pc.printf("Stacksize audiothread = %d\r\n", thisThread->stack_size());
    pc.printf("Stacksize audiothread max = %d\r\n", thisThread->max_stack());
    printf("\n\nAUDIO LOOPBACK EXAMPLE FOR DISCO-F769NI START:\n");

    BSP_AUDIO_OUT_Init(OUTPUT_DEVICE_HEADPHONE, 100, AUDIO_FREQUENCY_48K);
    
    BSP_AUDIO_OUT_Play(buf, BSIZE);
    while(1) {
       
    }
  //  const REAL_TIME_FREQUENCY = 220;
//const ANGULAR_FREQUENCY = REAL_TIME_FREQUENCY * 2 * Math.PI;

    /* Initialize Audio Recorder with 4 channels to be used */
   /* if (BSP_AUDIO_IN_AllocScratch(Scratch, SCRATCH_BUFF_SIZE) == AUDIO_OK) {
        printf("Scratch allokiert mit %d\r\n", SCRATCH_BUFF_SIZE);
        if(BSP_AUDIO_IN_Record(RecordBuffer, RECORD_BUFFER_SIZE)==AUDIO_OK) {
            printf("RecordBuffer initialisiert\r\n");
            if(BSP_AUDIO_IN_Init(BSP_AUDIO_FREQUENCY_44K, 16, 1) == AUDIO_OK ) {
                printf("BSP_AUDIO_IN_AllocScratch\n");
                
                while (1) {
                    
                }
            }
        }
    }*/
}

int main()
{
    pc.baud(115200);
    pc.printf("\f*** Joscha ***\r\n");
    
    

    
    //pc.printf("\tCreating printthread...\n");
    //Thread printThread(print_thread, NULL, osPriorityRealtime );
    
    //pc.printf("\tCreating ledthread...\r\n");
    //Thread ledThrea
    

    


   /* pc.printf("\tCreating ledthread...\n");
    Thread ledThread(osPriorityRealtime); 
    ledThread.start(&led_thread);*/
    

    
   /*  pc.printf("\tCreating guithread...\n");
    Thread guiThread(osPriorityHigh); 
    guiThread.start(&gui_thread);*/
    
    pc.printf("\tCreating audiothread...\r\n");
    Thread audioThread(osPriorityRealtime);
    audioThread.start(&audio_thread, &audioThread);

    

    
    while(true) {
    }


}
