#ifndef  __LCD_LOG_H__
#define  __LCD_LOG_H__

#include "stm32f769i_discovery_lcd.h" /* replace 'stm32xxx' with your EVAL board name, ex: stm324x9i_eval_lcd.h */
#include <stdio.h>

#define PEACH ((uint32_t) 0xFFf2c6a4)
#define ZINNWALDITE_BROWN ((uint32_t) 0xff270104)

/* Comment the line below to disable the scroll back and forward features */
#define     LCD_SCROLL_ENABLED      1 

/* Define the Fonts  */
#define     LCD_LOG_HEADER_FONT                   Font20
#define     LCD_LOG_FOOTER_FONT                   Font20
#define     LCD_LOG_TEXT_FONT                     Font20
            
/* Define the LCD LOG Color  */
#define     LCD_LOG_BACKGROUND_COLOR              PEACH
#define     LCD_LOG_TEXT_COLOR                    ZINNWALDITE_BROWN

#define     LCD_LOG_SOLID_BACKGROUND_COLOR        LCD_COLOR_BLUE
#define     LCD_LOG_SOLID_TEXT_COLOR              LCD_COLOR_WHITE

/* Define the cache depth */
#define     CACHE_SIZE              200
#define     YWINDOW_SIZE            22


#define LCD_LOG_PUTCHAR int std::fputc(int ch, FILE *f)

#define     LCD_CACHE_DEPTH     (YWINDOW_SIZE + CACHE_SIZE)

/* Define the display window settings */
#define     YWINDOW_MIN         1
 
typedef struct _LCD_LOG_line
{
  uint8_t  line[128];
  uint32_t color;

}LCD_LOG_line;

/**
  * @}
  */ 

/** @defgroup LCD_LOG_Exported_Macros
  * @{
  */ 
#define  LCD_ErrLog(...)    do { \
                                 LCD_LineColor = LCD_COLOR_RED;\
                                 printf("ERROR: ") ;\
                                 printf(__VA_ARGS__);\
                                 LCD_LineColor = LCD_LOG_DEFAULT_COLOR;\
                               }while (0)

#define  LCD_UsrLog(...)    do { \
                                 LCD_LineColor = LCD_LOG_TEXT_COLOR;\
                                 printf(__VA_ARGS__);\
                               } while (0)


#define  LCD_DbgLog(...)    do { \
                                 LCD_LineColor = LCD_COLOR_CYAN;\
                                 printf(__VA_ARGS__);\
                                 LCD_LineColor = LCD_LOG_DEFAULT_COLOR;\
                               }while (0)

extern uint32_t LCD_LineColor;

void LCD_LOG_Init(void);
void LCD_LOG_DeInit(void);
void LCD_LOG_SetHeader(uint8_t *Title);
void LCD_LOG_SetFooter(uint8_t *Status);
void LCD_LOG_ClearTextZone(void);
void LCD_LOG_UpdateDisplay (void);

#if (LCD_SCROLL_ENABLED == 1)
 ErrorStatus LCD_LOG_ScrollBack(void);
 ErrorStatus LCD_LOG_ScrollForward(void);
#endif

//#define LCD_LOG_PUTCHAR int __io_putchar(int ch)
//#define LCD_LOG_PUTCHAR int fputc(int ch, FILE *f)


#endif /* __LCD_LOG_H__ */
