// These functions are used to serialize the sensor data for transmission.


#include "serialize.h"


union float_bytes {
    float f;
    uint8_t b[sizeof(float)];
};


extern uint32_t serialize_sensor_to_bytes(struct sensor_data_raw in, uint8_t *out) {
    uint32_t i = 0;
    
    i += serialize_u16_to_bytes(in.reading_number, &out[i]);
    i += serialize_u16_to_bytes(in.voltage_battery, &out[i]);
    for(int j = 0; j < 9; j++) {
        i += serialize_u16_to_bytes(in.voltage_wire[j], &out[i]);
    }
    i += serialize_s16_to_bytes(in.temperature, &out[i]);
    
    return sizeof(struct sensor_data_raw);
}

extern uint32_t serialize_float_to_bytes(float in, uint8_t *out) {
    uint32_t i;
    union float_bytes data;
    
    data.f = in;
    for(i = 0; i < sizeof(float); i++) {
        out[i] = data.b[i];
    }
    
    return sizeof(float);
}

extern uint32_t serialize_u16_to_bytes(uint16_t in, uint8_t *out) {
    out[0] = (in >> 0);
    out[1] = (in >> 8);
    
    return sizeof(uint16_t);
}

extern uint32_t serialize_s16_to_bytes(int16_t in, uint8_t *out) {
    out[0] = (in >> 0);
    out[1] = (in >> 8);
    
    return sizeof(int16_t);
}

extern uint32_t serialize_bytes_to_sensor(uint8_t *in, struct sensor_data_raw *out) {
    uint32_t i = 0;
    
    i += serialize_bytes_to_u16(&in[i], &out->reading_number);
    i += serialize_bytes_to_u16(&in[i], &out->voltage_battery);
    for(int j = 0; j < 9; j++) {
        i += serialize_bytes_to_u16(&in[i], &out->voltage_wire[j]);
    }
    i += serialize_bytes_to_s16(&in[i], &out->temperature);
    
    return sizeof(struct sensor_data_raw);
}

extern uint32_t serialize_bytes_to_float(uint8_t *in, float *out) {
    uint32_t i;
    union float_bytes data;
    
    for(i = 0; i < sizeof(float); i++) {
        data.b[i] = in[i];
    }
    (*out) = data.f;
    
    return sizeof(float);
}

extern uint32_t serialize_bytes_to_u16(uint8_t *in, uint16_t *out) {
    (*out) = (((uint16_t)(in[1]) << 8) | ((uint16_t)(in[0]) << 0));
    
    return sizeof(uint16_t);
}

extern uint32_t serialize_bytes_to_s16(uint8_t *in, int16_t *out) {
    (*out) = (int16_t)(((uint16_t)(in[1]) << 8) | ((uint16_t)(in[0]) << 0));
    
    return sizeof(int16_t);
}









