#include "board_config.h"
#include "radio_sensor.h"
#include "sensors.h" //Sesing
#include "status_led.h" //Displys the atatus of the sensor through LED


#define MDOT_TIME_SLEEP (180) // Sleep time in seconds


DigitalIn button(PIN_INPUT_BUTTON);
#ifdef DEBUG_SERIAL_ENABLED
// Note: Apparently MTSLog is dependant on the initialization of the debug serial port.
Serial debug_serial(PIN_OUTPUT_DEBUG_UART_TX, PIN_OUTPUT_DEBUG_UART_RX, DEBUG_UART_BAUD);
#endif


void print_sensor_data(struct sensor_data_raw data);


int main(void)
{
    struct sensor_data_raw data;


    status_led_blink(STATUS_LED_POWER_ON);


    sensors_init(); //Initializes teh ADS1115, sets the devises switch and signals to 0
    radio_sensor_init(mts::MTSLog::DEBUG_LEVEL); //???


    status_led_blink(STATUS_LED_CONNECTED);


    while (true) {
        sensors_read(&data);
        
        
        // Print the sensor data to be transmitted.
        print_sensor_data(data);


        // Transmit the sensor data.
        if(radio_sensor_transmit(data) == 0) {
            data.reading_number++;
            status_led_blink(STATUS_LED_RADIO_ACTIVITY);
            logInfo("Successfully transmited sensor data.");
        } else {
            logError("Failed to transmit sensor data.");
        }


        // Set the wakeup pin, save the configuration of the pins and then configure them for low power mode.
        dot->setWakePin(PIN_INPUT_BUTTON);
        sleep_save_io();
        sleep_configure_io();

        // Send the MDot to sleep.
        dot->sleep(MDOT_TIME_SLEEP, mDot::RTC_ALARM_OR_INTERRUPT, false);

        // Restore the save pin configuration.
        sleep_restore_io();

        if(button.read() == 1) {
            logDebug("Button press.");
            status_led_blink(STATUS_LED_CHECK);
        }
    }
}

void print_sensor_data(struct sensor_data_raw data)
{
    logInfo("reading #:   %7u", data.reading_number);
    logInfo("battery:     %7u", data.voltage_battery);
    logInfo("signal 1-1:  %7u", data.voltage_wire[0]);
    logInfo("signal 1-2:  %7u", data.voltage_wire[1]);
    logInfo("signal 1-3:  %7u", data.voltage_wire[2]);
    logInfo("signal 2-1:  %7u", data.voltage_wire[3]);
    logInfo("signal 2-2:  %7u", data.voltage_wire[4]);
    logInfo("signal 2-3:  %7u", data.voltage_wire[5]);
    logInfo("signal 3-1:  %7u", data.voltage_wire[6]);
    logInfo("signal 3-2:  %7u", data.voltage_wire[7]);
    logInfo("signal 3-3:  %7u", data.voltage_wire[8]);
    logInfo("temperature: %7i", data.temperature);
}