#ifndef BOARD_CONFIG_H
#define BOARD_CONFIG_H


#include "mbed.h"


/* PIN ALLOCATIONS ************************************************************/


#define PIN_OUTPUT_LED_EXTERNAL    PA_0
#define PIN_OUTPUT_SENSOR_2_SIGNAL PA_1
#define PIN_OUTPUT_ESP_UART_TX     PA_2
#define PIN_OUTPUT_ESP_UART_RX     PA_3
#define PIN_OUTPUT_SENSOR_1_SIGNAL PA_4
#define PIN_OUTPUT_MAX_SPI_SCK     PA_5
#define PIN_OUTPUT_MAX_SPI_MISO    PA_6
#define PIN_OUTPUT_MAX_SPI_MOSI    PA_7
#define PIN_OUTPUT_ESP_POWER       PA_7
#define PIN_OUTPUT_ADS_I2C_SCL     PA_8
#define PIN_OUTPUT_DEBUG_UART_TX   PA_9
#define PIN_OUTPUT_DEBUG_UART_RX   PA_10
#define PIN_OUTPUT_SENSOR_POWER    PA_11
//#define  PA_13 // JTAG
//#define  PA_14 // JTAG

#define PIN_OUTPUT_MAX_SPI_CS      PB_0
#define PIN_OUTPUT_LED_INTERNAL    PB_1
//#define  PB_3 // JTAG
//#define  PB_4 // JTAG

#define PIN_OUTPUT_SENSOR_3_SIGNAL PC_1
#define PIN_OUTPUT_ADS_I2C_SDA     PC_9
#define PIN_INPUT_BUTTON           PC_13


/* DEBUG SERIAL SETTINGS *****************************************************/


extern Serial debug_serial;
#define DEBUG_UART_BAUD 115200
// Uncomment "#define DEBUG_SERIAL_ENABLED" to enable debug printing external to the logging system.
#define DEBUG_SERIAL_ENABLED
#ifdef DEBUG_SERIAL_ENABLED
    #define DEBUG_PRINTF(...) debug_serial.printf(__VA_ARGS__)
#else
    #define DEBUG_PRINTF(...)
#endif


/* RADIO SETTINGS *************************************************************/


// Channel plan options:
//      CP_US915
//      CP_AU915
//      CP_EU868
//      CP_KR920
//      CP_AS923
//      CP_AS923_JAPAN
//      CP_IN865
#define RADIO_CHANNEL_PLAN CP_AU915


/* SENSOR READING SETTINGS ****************************************************/


// Scaling factors to turn raw sensor data into proper readings.
#define BATTERY_VOLTAGE_SCALE     (1193.2f)
#define TEMPERATURE_READING_SCALE (4)


/* IMPORTANT DATA STRUCTURES **************************************************/


// This structure contains the raw sensor data.
struct sensor_data_raw {
    uint16_t reading_number;
    uint16_t voltage_battery;
    uint16_t voltage_wire[9];
    int16_t temperature;
};

// This structure contains the actual scaled readings.
struct sensor_data {
    uint16_t reading_number;
    float voltage_battery;
    uint16_t voltage_wire[9];
    float temperature;
    float rssi;
};


#endif // BOARD_CONFIG_H