#include "status_led.h"


static DigitalOut status_led_external(PIN_OUTPUT_LED_EXTERNAL);
static DigitalOut status_led_internal(PIN_OUTPUT_LED_INTERNAL);

static Ticker status_led_ticker;


static void status_led_ticker_callback(void) {
    status_led_external = !status_led_external;
}


extern void status_led_set(uint8_t state_external, uint8_t state_internal) {
    if(state_external == 0) status_led_external = 0;
    else status_led_external = 1;
    
    if(state_internal == 0) status_led_internal = 0;
    else status_led_internal = 1;
}

extern void status_led_blink(uint8_t type)
{
    uint8_t blink_count;
    float blink_time_on, blink_time_off;

    switch(type) {
        case STATUS_LED_POWER_ON:

            blink_count = 1;
            blink_time_on = 0;
            blink_time_off = 3;
            break;

        case STATUS_LED_RADIO_ACTIVITY:

            blink_count = 1;
            blink_time_on = 0;
            blink_time_off = 0.3;
            break;

        case STATUS_LED_CONNECTED:

            blink_count = 2;
            blink_time_on = 0.5;
            blink_time_off = 0.3;
            break;

        case STATUS_LED_CHECK:

            blink_count = 3;
            blink_time_on = 0.5;
            blink_time_off = 0.3;
            break;

        case STATUS_LED_ERROR:

            blink_count = 2;
            blink_time_on = 0.3;
            blink_time_off = 0.5;
            break;

        default:

            blink_count = 0;
            blink_time_on = 0;
            blink_time_off = 0;
            break;

    }

    for(uint8_t i = 0; i < blink_count; i++) {
        if(i > 0) wait(blink_time_on);
        status_led_external = 0;
        wait(blink_time_off);
        status_led_external = 1;
    }
    status_led_external = 1;

}

extern void status_led_blink_start(double frequency) {
    status_led_ticker.attach(&status_led_ticker_callback, 0.5/frequency); // '0.5' because a full blink requires two state changes.
}

extern void status_led_blink_stop(void) {
    status_led_ticker.detach();
}