#ifndef SERIALIZE_H
#define SERIALIZE_H


#include "board_config.h"
#include "stdint.h"


extern uint32_t serialize_sensor_to_bytes(struct sensor_data_raw in, uint8_t *out);
extern uint32_t serialize_float_to_bytes(float in, uint8_t *out);
extern uint32_t serialize_u16_to_bytes(uint16_t in, uint8_t *out);
extern uint32_t serialize_s16_to_bytes(int16_t in, uint8_t *out);

extern uint32_t serialize_bytes_to_sensor(uint8_t *in, struct sensor_data_raw *out);
extern uint32_t serialize_bytes_to_float(uint8_t *in, float *out);
extern uint32_t serialize_bytes_to_u16(uint8_t *in, uint16_t *out);
extern uint32_t serialize_bytes_to_s16(uint8_t *in, int16_t *out);


#endif // SERIALIZE_H