#include "sensors.h"


static I2C ads1115_i2c(PIN_OUTPUT_ADS_I2C_SDA, PIN_OUTPUT_ADS_I2C_SCL);
static SPI max31855_spi(PIN_OUTPUT_MAX_SPI_MOSI, PIN_OUTPUT_MAX_SPI_MISO, PIN_OUTPUT_MAX_SPI_SCK);
static Adafruit_ADS1115 ads1115(&ads1115_i2c);
static max31855 max31855(max31855_spi, PIN_OUTPUT_MAX_SPI_CS);

static DigitalOut sensor_power(PIN_OUTPUT_SENSOR_POWER);
static DigitalOut sensor_signal_1(PIN_OUTPUT_SENSOR_1_SIGNAL);
static DigitalOut sensor_signal_2(PIN_OUTPUT_SENSOR_2_SIGNAL);
static DigitalOut sensor_signal_3(PIN_OUTPUT_SENSOR_3_SIGNAL);


extern void sensors_init(void) {
    sensor_power = 0;
    
    sensor_signal_1 = 0;
    sensor_signal_2 = 0;
    sensor_signal_3 = 0;
    
    ads1115.setGain(GAIN_ONE); //Sets the gane of the ADS1115 GAIN_ONE (for an input range of +/-4.096V)
}

extern void sensors_read(struct sensor_data_raw *data) {
    sensor_power = 1;
    
    sensor_signal_3 = 1;
    
    wait_ms(10);
    data->voltage_wire[6] = ads1115.readADC_SingleEnded(1);
    data->voltage_wire[7] = ads1115.readADC_SingleEnded(2);
    data->voltage_wire[8] = ads1115.readADC_SingleEnded(3);
    
    
    sensor_signal_3 = 0;
    sensor_signal_2 = 1;
    
    wait_ms(10);
    data->voltage_wire[3] = ads1115.readADC_SingleEnded(1);
    data->voltage_wire[4] = ads1115.readADC_SingleEnded(2);
    data->voltage_wire[5] = ads1115.readADC_SingleEnded(3);
    
    
    sensor_signal_2 = 0;
    sensor_signal_1 = 1;
    
    wait_ms(10);
    data->voltage_wire[0] = ads1115.readADC_SingleEnded(1);
    data->voltage_wire[1] = ads1115.readADC_SingleEnded(2);
    data->voltage_wire[2] = ads1115.readADC_SingleEnded(3);
    
    sensor_signal_1 = 0;
    
    data->voltage_battery = ads1115.readADC_SingleEnded(0);
    
    max31855.read_temp_raw(&data->temperature);
    
    sensor_power = 0;
}