#include "status_led.h"


static DigitalOut status_led_external(PIN_OUTPUT_LED_EXTERNAL);
static DigitalOut status_led_internal(PIN_OUTPUT_LED_INTERNAL);


extern void status_led_blink(uint8_t type) {
    uint8_t blink_count;
    float blink_time_on, blink_time_off;
    
    switch(type) {
    case STATUS_LED_POWER_ON:
    
        blink_count = 1;
        blink_time_on = 3;
        blink_time_off = 0;
        break;
    
    case STATUS_LED_RADIO_ACTIVITY:
    
        blink_count = 1;
        blink_time_on = 0.3;
        blink_time_off = 0;
        break;
    
    case STATUS_LED_CONNECTED:
    
        blink_count = 2;
        blink_time_on = 0.3;
        blink_time_off = 0.5;
        break;
    
    case STATUS_LED_CHECK:
    
        blink_count = 3;
        blink_time_on = 0.3;
        blink_time_off = 0.5;
        break;
    
    case STATUS_LED_ERROR:
    
        blink_count = 2;
        blink_time_on = 0.5;
        blink_time_off = 0.3;
        break;
    
    default:
    
        blink_count = 0;
        blink_time_on = 0;
        blink_time_off = 0;
        break;
    
    }
    
    for(uint8_t i = 0; i < blink_count; i++) {
        if(i > 0) wait(blink_time_off);
        status_led_external = 1;
        wait(blink_time_on);
        status_led_external = 0;
    }
}
