#include "mbed.h"

//Serial ports definition
int BaudRate =115200; //ESP8266
Serial pc(USBTX, USBRX,BaudRate); // tx, rx (PA_9,PA_10)
Serial esp(PA_2,PA_3,BaudRate); // tx, rx

//Pins definitiom
DigitalOut led1(XBEE_RSSI); //XBEE_RSSI PA_8
DigitalOut led2(PC_9); //Second LED
DigitalOut reset(PB_0); //Pin to reset the ESP

//Variables definition
Timer t;
int  count,ended,timeout;
char buf[1024];
char snd[255];
char ssid[32] = "Jorgie's iPhone";     // enter WiFi router ssid inside the quotes
char pwd [32] = "jorge123"; // enter WiFi router password inside the quotes


void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate(),ESP_HardwareReset(),ESPconnect();


int main()
{
    ESP_HardwareReset(); //ESP8266 Hardware Reset
//ESPsetbaudrate();   //Difines ESP8266 baudrate !!!!!!!!!!!!!!!!!Currently not working!!!!!!!!!!!!!!!!!
//ESPconfig(); //ESP8266 configuration
    ESPconnect();
}

void ESPconnect()
{
    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);
    wait(5);

    pc.printf("\n---------- Get IP's ----------\r\n");
    strcpy(snd, "AT+CIFSR\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
    wait(1);

    pc.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "AT+CIPSTATUS\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);

    pc.printf("\n\n\n  If you get a valid (non zero) IP, ESP8266 has been set up.\r\n");
    pc.printf("  Run this if you want to reconfig the ESP8266 at any time.\r\n");
    pc.printf("  It saves the SSID and password settings internally\r\n");
    wait(10);
}


void ESP_HardwareReset()
{
    reset=0; //hardware reset for 8266
    pc.printf("\f\n\r-------------ESP8266 Hardware Reset-------------\n\r");
    pc.printf("Done \n\r");
    wait(0.5);
    reset=1;
    timeout=2;
    getreply();
}


void ESPsetbaudrate()
{
    pc.printf("\f\n\r-------------ESP8266 BaudRait Definition-------------\n\r");
    char TempString1[50];
    sprintf(TempString1,"AT+CIOBAUD=%d,\r\n",BaudRate);
    strcpy(snd, TempString1);   // change the numeric value to the required baudrate
    SendCMD();
}


void ESPconfig()
{
    wait(5);
    strcpy(snd,"AT\r\n");
    SendCMD();
    timeout=2;
    getreply();
    pc.printf(buf);
    wait(1);

    pc.printf("\f---------- Starting ESP Config ----------\r\n\n");
    pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"AT+RST\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
    wait(2);

    pc.printf("\n---------- Get Version ----------\r\n");
    strcpy(snd,"AT+GMR\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(3);

    // Currently not working  !!!!!!!!!!!!!!!!!Currently not working!!!!!!!!!!!!!!!!!
    pc.printf("\n---------- Get UART Definition ----------\r\n");
    strcpy(snd,"AT+CIOBAUD?\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(3);

    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "AT+CWMODE=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(2);

    // set CIPMUX to 0=Single,1=Multi
    pc.printf("\n---------- Setting Connection Mode ----------\r\n");
    strcpy(snd, "AT+CIPMUX=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
    wait(2);

    pc.printf("\n---------- Listing Access Points ----------\r\n");
    strcpy(snd, "AT+CWLAP\r\n");
    SendCMD();
    timeout=15;
    getreply();
    pc.printf(buf);
    wait(2);
}


void SendCMD()
{
    pc.printf("%s", snd);
    esp.printf("%s", snd);
}

void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}
