#include "mbed.h"
#include "MODSERIAL.h"

//Define objects
AnalogIn    emg_biceps(PTB0); //Analog input
PwmOut      red(LED_RED); //PWM output
Ticker timer;
MODSERIAL pc(USBTX,USBRX,64,1024);

//high pass filter constantes 15Hz cutoff 4e orde
#define NUM0 0.2754 // constante
#define NUM1 -1.1017 // z^-1
#define NUM2 1.6525 // z^-2etc.
#define NUM3 -1.1017
#define NUM4 0.2754

#define DEN0 1 // constante
#define DEN1 -1.5704
#define DEN2 1.2756
#define DEN3 -0.4844
#define DEN4 0.0762

//lowpass filter constantes 40 Hz 4e orde
#define NUM0_2 0.4328 // constante
#define NUM1_2 1.7314 // z^-1
#define NUM2_2 2.5971 // z^-2etc.
#define NUM3_2 1.7314
#define NUM4_2 0.4328


#define DEN0_2 1 // constante
#define DEN1_2 2.3695
#define DEN2_2 2.3140
#define DEN3_2 1.0547
#define DEN4_2 0.1874

//lowpass filter constantes 4z 4e orde
#define NUM0_3 0.0002 // constante
#define NUM1_3 0.0007 // z^-1
#define NUM2_3 0.0011 // z^-2etc.
#define NUM3_3 0.0007
#define NUM4_3 0.0002


#define DEN0_3 1 // constante
#define DEN1_3 -3.3441
#define DEN2_3 4.2389
#define DEN3_3 -2.4093
#define DEN4_3 0.5175

//variabelen definieren
float in0_biceps =0;
static float in1_biceps =0, in2_biceps = 0, in3_biceps = 0, in4_biceps = 0;
static float out0_biceps = 0, out1_biceps = 0 , out2_biceps = 0, out3_biceps = 0, out4_biceps = 0;

float in0_2_biceps =0;
static float in1_2_biceps =0, in2_2_biceps = 0, in3_2_biceps = 0, in4_2_biceps = 0;
static float out0_2_biceps = 0, out1_2_biceps = 0 , out2_2_biceps = 0, out3_2_biceps = 0, out4_2_biceps = 0;

float in0_3_biceps =0;
static float in1_3_biceps =0, in2_3_biceps = 0, in3_3_biceps = 0, in4_3_biceps = 0;
static float out0_3_biceps = 0, out1_3_biceps = 0 , out2_3_biceps = 0, out3_3_biceps = 0, out4_3_biceps = 0;
/** Looper function
* functions used for Ticker and Timeout should be of type void <name>(void)
* i.e. no input arguments, no output arguments.
* if you want to change a variable that you use in other places (for example in main)
* you will have to make that variable global in order to be able to reach it both from
* the function called at interrupt time, and in the main function.
* To make a variable global, define it under the includes.
* variables that are changed in the interrupt routine (written to) should be made
* 'volatile' to let the compiler know that those values may change outside the current context.
* i.e.: "volatile float emg_value;" instead of "float emg_value"
* in the example below, the variable is not re-used in the main function, and is thus declared
* local in the looper function only.
**/

float filter(float value, int sig_number){
    switch(sig_number){
        case 1:
            break;
        case 2:
            break;
        case 3:
            break;
        case 4:
            break;
    }
}

void looper()
{   
    
    float emg_value;
    /*put raw emg value both in red and in emg_value*/
    
    /*send value to PC. use 6 digits after decimal sign*/
    
    // signaal filteren op 15 Hz HIGHPASS
    in4_biceps = in3_biceps; in3_biceps = in2_biceps; in2_biceps = in1_biceps; in1_biceps = in0_biceps;
    in0_biceps = emg_biceps.read();
    out4_biceps = out3_biceps; out3_biceps = out2_biceps; out2_biceps = out1_biceps; out1_biceps = out0_biceps;           
    out0_biceps = (NUM0*in0_biceps + NUM1*in1_biceps + NUM2*in2_biceps + NUM3*in3_biceps + NUM4*in4_biceps - DEN1*out1_biceps - DEN2*out2_biceps - DEN3*out3_biceps - DEN4*out4_biceps ) / DEN0;                      
    
    //signaal filteren op 40 HZ LOWPASS
    in4_2_biceps = in3_2_biceps; in3_2_biceps = in2_2_biceps; in2_2_biceps = in1_2_biceps; in1_2_biceps = in0_2_biceps;
    in0_2_biceps = out0_biceps;
    out4_2_biceps = out3_2_biceps; out3_2_biceps = out2_2_biceps; out2_2_biceps = out1_2_biceps; out1_2_biceps = out0_2_biceps;           
    out0_2_biceps = (NUM0_2*in0_2_biceps + NUM1_2*in1_2_biceps + NUM2_2*in2_2_biceps + NUM3_2*in3_2_biceps + NUM4_2*in4_2_biceps - DEN1_2*out1_2_biceps - DEN2_2*out2_2_biceps - DEN3_2*out3_2_biceps - DEN4_2*out4_2_biceps ) / DEN0_2;
    
    
    //signaal filteren op 5Hz LOWPASS
    in4_3_biceps = in3_3_biceps; in3_3_biceps = in2_3_biceps; in2_3_biceps = in1_3_biceps; in1_3_biceps = in0_3_biceps;
    in0_3_biceps = abs(out0_2_biceps);
    out4_3_biceps = out3_3_biceps; out3_3_biceps = out2_3_biceps; out2_3_biceps = out1_3_biceps; out1_3_biceps = out0_3_biceps;           
    out0_3_biceps = (NUM0_3*in0_3_biceps + NUM1_3*in1_3_biceps + NUM2_3*in2_3_biceps + NUM3_3*in3_3_biceps + NUM4_3*in4_3_biceps - DEN1_3*out1_3_biceps - DEN2_3*out2_3_biceps - DEN3_3*out3_3_biceps - DEN4_3*out4_3_biceps ) / DEN0_3;    
    emg_value = out0_3_biceps;
    if(pc.rxBufferGetSize(0)-pc.rxBufferGetCount() > 30)
        pc.printf("%.6f\n",emg_value);
    /**When not using the LED, the above could also have been done this way:
    * pc.printf("%.6\n", emg0.read());
    */
}

int main()
{
    /*setup baudrate. Choose the same in your program on PC side*/
    pc.baud(115200);
    /*set the period for the PWM to the red LED*/
    red.period_ms(2);
    /**Here you attach the 'void looper(void)' function to the Ticker object
    * The looper() function will be called every 0.001 seconds.
    * Please mind that the parentheses after looper are omitted when using attach.
    */
    timer.attach(looper, 0.01);
    while(1) //Loop
    {
      /*Empty!*/
      /*Everything is handled by the interrupt routine now!*/
    }
}