#include "mbed.h"
#include "MPU6050.h"
#include "REFVALUES.h"
//activo
// Debbuging led
DigitalOut myled(LED1);
// klkl
// Puerto serial
Serial pc(USBTX, USBRX);

// Objeto MPU6050
MPU6050 mpu(PF_15, PF_14);

// Threads
Thread sampleAccelero();
Thread printDebug();

//Mutex
Mutex semaforo;

//Mailbox
Mail<float, 1> mail_box;




void medicion() {
    
    pc.baud(9600);
    
    
    
    float acce[3];
    
    mpu.setAcceleroRange(2);
    mpu.setBW(6);
   
    // Test the connection
    if (mpu.testConnection())
        pc.printf("MPU6050 test passed \r\n");    
    else
        pc.printf("MPU6050 test failed \r\n");
    
    
    float x;
    float y;
    
    while(1) {
        
        wait(0.016);
        mpu.getAccelero(acce);
        
        
        x = (float)acce[0] / (9.81);
        y = (float)acce[1] / (9.81);
            
        
        //pc.printf("X = %f  \t Y = %f \t Z = %f \r\n", x , y, z);
        pc.printf("X = %f  \t Y = %f \r\n", x , y);
        //pc.printf("%f\r\n", x);
    
    }
}

int main()
{
    sampleAccelero.start(medicion);
}
