#include "mbed.h"                   //Se declara la librería mbed.
#include "rtos.h"

DigitalOut led1(LED1);
Serial pc(USBTX, USBRX, 9600);      // tx, rx Conunicación Serial con la PC

DigitalIn CTS(p11, PullUp);          // Pin Digital de entrada "CTS" en modo Pull-Up, para encontrarse normalmente a VCC cuando no haya un pulso. 
DigitalOut RTS(p12, 1);              // Pin Digital de Salida "RTS"; Predefinido para valer 1 en su estado inactivo dentro del código.

Serial device(p13, p14, 9600);       // tx, rx Comunicación Serial con el Módulo STX3
int flag=1;                         // Declaración de la Bandera.
int incomingByte=0;
Thread thread;

int packet[15]; //int or char
int num = 0;

void clearPacket(){
    num = 0;
    for(int i = 0; i < 15 ; i++)
        packet[i] = 0;
}

void respuesta(){
    while(1){
        if(device.readable()){   // Se esperan datos provenientes del TX del módulo STX3
            incomingByte = device.getc();
            packet[num] = incomingByte;
            //pc.printf("%X",incomingByte);  // Format specifier
            //pc.printf(" ");
            num++;
        }
    }
}

void waitCTS(){
    Thread::wait(200);                                                    // Se da un tiempo para que el analizador se estabilice
    incomingByte=0;
    RTS=0;                                                      // Se manda un pulso en bajo en RTS, para inicial el proceso de transmisión
    while(flag==1){// Flag inicialmente vale 1, así que el ciclo while cambiará hasta que esa condición no se cumpla           
        flag=CTS.read();        // Cuando entra el ciclo, se iguala flag a CTS, el cual cuando cambie a 0 provocará que termine el while (máx 125 ms)
    }
}

void postCommand(){
    Thread::wait(50);             
    RTS=1;
    Thread::wait(150);
    flag=1;
}

void queryESN();
        
int main(){ 
    thread.start(respuesta);
    while(1){
        switch(pc.getc()){
            case '9':
                queryESN();
                break;
        }
    }
}

//0x01 Query ESN
void queryESN(){
    

    waitCTS();
    Thread::wait(50);
     
    device.putc(0XAA);      
    device.putc(0X05);
    device.putc(0X11);
    device.putc(0X50);
    device.putc(0XD5);  
    
    pc.printf("Existe comunicación Serial ");
    
    
    postCommand();
    
    pc.printf("\n\nElectronic Serial Number: ");
    
    pc.printf("%u",packet[3]);
    pc.printf("%u",packet[4]);
    pc.printf("%u",packet[5]);
    pc.printf("%u",packet[6]);
    pc.printf("\n");
    
    pc.printf("\n\nExiste comunicación I2C");
    
    pc.printf("\n\nTemperatua actual del Payload en grados centigrados: 20");
    
    clearPacket();
    
        
}