/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : EXAMEN_2do_PARCIAL
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed
**    Compilador     : Mbed Online C Compiler
**    Version        : Mbed-OS 5.15.0
**    Fecha/Hora     : 03/11/2021, 10:00 p.m, # CodeGen: 0
**    Descripción    :
**                      METODOS NÚMERICOS Y MENÚ 
**   Componentes     : 
**   Autores         :
**                      Peña Paz Jorge Eduardo
**
**   Versión        :  Final
**   Revisión       :  A
**   Release        :  0
**   Bugs & Fixes   :  
**   Date           :  03/11/2021
**                      Inicio de plantilla 
** ###########################################################################*/

/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:                       I N C L U D E S
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <iostream>
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "wchar.h"


/*
:...............................................................................
:                       D E F I N I C I O N E S
:...............................................................................
*/
#define on 0                                                                    // Estado para boton presionado
#define off 1                                                                   // Estado para boton sin presionar
#define hold 2                                                                  // Estado para boton mantenido
#define release 3                                                               // Estado para boton liberado
#define FALSE 0                                                                 // Estado FALSO
#define TRUE 1                                                                  // Estado VERDADERO
#define Baud_Rate 115200                                                        // Velocidad de Transmisión (Bauds)
#define e 2.718281828

/*
*===============================================================================
*
*           C O N F I G U R A C I O N    D E    P U E R T O S
*
*===============================================================================
*/
// *****    Host PC Terminal Communication channels
Serial      terminal(PA_2, PA_3);                                                     // Tx, Rx - Terminal Serial (TTL Level) (Default Rate: 9600)
DigitalOut  myled(LED1);
//Serial      terminal(USBTX, USBRX,115200);                                    // Tx, Rx, Baud Rate - Terminal Serial por USB @ 115,200 Bauds
//Serial      terminal(PA_9, PA_10);                                            // Tx, Rx  Using MAX3232 or BlueTooth

/*
#===============================================================================
|
|                           A R E A   D E   D A T O S
|
#===============================================================================
*/
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
char opcion;
float xi, xu, x0, respuesta;
int n;
float vv = 0.0;
float xr = 0.0;
float ea = 0.0;
float es = 0.0005;
float ev = 0.0;
float xrantes = 0.0;
float fxi = 0.0;
float fxu = 0.0;
float ec = 0.0;
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Setup(void);                                                               // Función que inicializa la Tarjeta

void pantallaPrincipal();

void limpiar_pantalla(void);
void errores();
float FalsaPosicion(float, float);
float FalsaPosicionevaluar(float);

float NewtonRaphson(float);
float NewtonRevaluarfx(float);
float NewtonRevaluardx(float);

float Secante(float, float);
float Secanteevaluar(float);
float Secanteevaluardx(float);

float Biseccion(float, float);
float Biseccionevaluar(float);

void IngresaArray(int, float *);
float InterpolacionNewton();
float Lagrange();

void GaussJordan();
void imprimir(int filas, int columnas, float *);
void pivotear(int filas, int columnas, float *, float *, float *, int j);

void IntegracionNumerica();
float f(float x);
/* END definitions */

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main(){
    // Inicialización de variables, puertos e interrupciones.

    confSysClock();                                                             // Configure System Clock (72 MHz HSE clock, 48 MHz USB clock)
    
    Setup();
    
    while(1){
        pantallaPrincipal();
        myled = !myled;
        limpiar_pantalla();
        printf("\r\n\t\t\tMENU METODOS NUMERICOS\n\n");
        printf("\r\t1. Punto Fijo (Falsa Posicion)\n");
        printf("\r\t2. Newton-Rapson\n");
        printf("\r\t3. Secante\n");
        printf("\r\t4. Biseccion\n");
        printf("\r\t5. Interpolacion de Newton\n");
        printf("\r\t6. Integracion numerica\n");
        printf("\r\t7. Gauss-Jordan\n");
        printf("\r\t8. Lagrange\n");
        printf("\r\t9. Minimos cuadrados\n");
        printf("\r\t10. Simpson\n");
        printf("\r\t11. Salir\n\n");
        printf("\r\tDe una opcion: ");
        opcion = terminal.getc();
        terminal.printf("%c\r\n", opcion);
        limpiar_pantalla();
        
        switch (opcion)
        {
        case '1':
            terminal.printf ("\e\t\t[1;31mPUNTOFIJO\n\r\e[0m"); 
            terminal.printf("xi: ");
            terminal.scanf("%f", &xi);
            terminal.printf("%f\n\r", xi);
            terminal.printf("xu: ");
            terminal.scanf("%f", &xu);
            terminal.printf("%f\n\r", xu);
            respuesta = FalsaPosicion(xi, xu);
            terminal.printf("Raiz: %5.6f\r\n", respuesta);
            break;
        case '2':
            terminal.printf ("\e\t\t[1;31mNEWTON-RAPSON\n\r\e[0m"); 
            terminal.printf("x0: ");
            terminal.scanf("%f", &x0);
            terminal.printf("%f\n\r", x0);
            respuesta = NewtonRaphson(x0);
            terminal.printf("Raiz mas grande : %5.6f\r\n", respuesta);
            break;
        case '3':
            terminal.printf ("\e\t\t[1;31mSECANTE \n\r\e[0m"); 
            terminal.printf("xi-0: ");
            terminal.scanf("%f", &x0);
            terminal.printf("%f\n\r", x0);
            terminal.printf("xi: ");
            terminal.scanf("%f", &xi);
            terminal.printf("%f\n\r", xi);
            respuesta = Secante(x0, xi);
            terminal.printf("Valor de la raiz: %5.6f\r\n", respuesta);
            break;
        case '4':
            terminal.printf ("\e\t\t[1;31BISECCION \n\r\e[0m"); 
            terminal.printf("xi: ");
            terminal.scanf("%f", &xi);
            terminal.printf("%f\n\r", xi);
            terminal.printf("xu: ");
            terminal.scanf("%f", &xu);
            terminal.printf("%f\n\r", xu);
            respuesta = Biseccion(xi, xu);
            terminal.printf("Valor de la raiz: %5.6f\r\n", respuesta);
            break;
        case '5':
            terminal.printf ("\e\t\t[1;31mNEWTON  \n\r\e[0m"); 
            respuesta = InterpolacionNewton();
            terminal.printf("Respuesta: %5.6f\r\n", respuesta);
            break;
        case '6':
            terminal.printf ("\e\t\t[1;31mLAGRANGE  \n\r\e[0m"); 
            respuesta = Lagrange();
            terminal.printf("Respuesta: %5.6f\r\n", respuesta);
            break;
        case '7':
           terminal.printf ("\e\t\t[1;31mGAUSS-JORDAN  \n\r\e[0m"); 
            GaussJordan();
            break;
        case '8':
            terminal.printf ("\e\t\t[1;31mINTEGRACION  \n\r\e[0m"); 
            IntegracionNumerica();
            break;
        case '9':
            terminal.printf ("\e\t\t[1;31mMINIMOS  \n\r\e[0m"); 
            break;
        default:
            terminal.printf ("\033[1;31mroot@STM32 \033[0m:-$ Elije una opcion valida.\n\r");
            break;
        }
        terminal.printf ("\x1B[1;32m\n\nPresiona una tecla para continuar...\n\r\x1B[0m");
        terminal.getc();
    }
}
/* END main */

/*
+===============================================================================
|
|                   V E C T O R E S    D E    I N T E R R U P C I O N
|
+===============================================================================
*/
 
/* END Events */ 
/*
 ______________________________________________________________________________
/______________________________________________________________________________\
|                                                                              |
|                   F U N C I O N E S     P R O T O T I P O                    |
|______________________________________________________________________________|
 \_____________________________________________________________________________/
*/
                // Las Funciones Prototipo van aquí !
void Setup(){
    terminal.baud(Baud_Rate);                                                   // Se configura la velocidad de transmisión
}

void pantallaPrincipal(){
    terminal.printf("\033[1;37;41m       ____________     ____________     ____________       \033[0m\n");
    terminal.printf("\r\033[1;37;41m      /___________/|   /___________/|   /_____    __/|      \033[0m\n");
    terminal.printf("\r\033[1;37;41m      |___     ___|/   |   _____   ||   |     |  |  ||      \033[0m\n");
    terminal.printf("\r\033[1;37;41m          |   | |      |  | ____|  ||   |      | |  ||      \033[0m\n");
    terminal.printf("\r\033[1;37;41m          |   | |      |  |/____|  ||   |   __  ||  ||      \033[0m\n");
    terminal.printf("\r\033[1;37;41m          |   | |      |    _______|/   |  || |     ||      \033[0m\n");
    terminal.printf("\r\033[1;37;41m       ___|   | |_     |    ||          |  ||  |    ||      \033[0m\n");
    terminal.printf("\r\033[1;37;41m      /___|   |___/|   |    ||          |  ||   |   ||      \033[0m\n");
    terminal.printf("\r\033[1;37;41m      |___________|/   |____|/          |__|/    |__|/      \033[0m\n\n");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ Bienvenido al shell de Tera term\n\r\e\033[1;31mroot@STM32\033[0m:-$ ");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ ");
    char opcionP = terminal.getc();
    terminal.printf("apt-get install \e[1;37mINSTITUTO POLITECNICO NACIONAL.exe\033[0m\n");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ ");
    opcionP = terminal.getc();
    terminal.printf("\rConnecting to \033[1;37mESIME Unidad Zacatenco\033[0m ... connected.\n");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ ");
    opcionP = terminal.getc();
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ ls\n");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$\n\r\e[1;32mAnalisis numerico\tHack the NASA\tHack AEM\tPython\n\033[0m");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ ");
    opcionP = terminal.getc();
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ cd Analisis_Numerico\n");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ ls\n");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$\n\rCarrera: Ingenieria en comunicaciones y electronica\n\n\rAlumno: Penha Paz Jorge Eduardo\t\tGrupo: 4CV6\n\n\rProfesor: Antulio Morgado\n\n\rEXAMEN 2DO PARCIAL\n");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ ");
    opcionP = terminal.getc();
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ cd EXAMEN 2DO PARCIAL\n");
    terminal.printf("\r\033[1;31mroot@STM32\033[0m:-$ ");
}

void limpiar_pantalla()
{
    //ANSI Terminal Commands
    terminal.printf("\x1B[2J");
    terminal.printf("\x1B[H");
}

//calculo del error
void errores()
{
    //error aproximado
    ea = (abs((xr - xrantes) / xr)) * 100;
    if (vv == 0.0)
    {
        //solo considera el error aproximado
        ec = ea;
    }
    else
    {
        //se considera el error verdadero
        ec = (abs((vv - xr) / vv)) * 100;
        ev = ec; //lo guardo para despues mostrarlo
    }
}
//falsa posicion----------------------------------------------------------------
float FalsaPosicion(float x, float y)
{
    xi = x;
    xu = y;
    do
    {
        xrantes = xr;
        fxi = FalsaPosicionevaluar(xi);
        fxu = FalsaPosicionevaluar(xu);
        xr = xu - ((fxu * (xi - xu)) / (fxi - fxu));
        //evaluo la fx
        fxi = FalsaPosicionevaluar(xi);
        fxu = FalsaPosicionevaluar(xr);
        //errores
        errores();
        //Paso 3 evaluar comparar
        if ((fxi * fxu) < 0)
        {
            xu = xr;
        }
        else if ((fxi * fxu) > 0)
        {
            xi = xr;
        }
        else if (fxi * fxu == 0)
        {
            return xr;
        }

    } while (ec > es);

    return xr;
}
float FalsaPosicionevaluar(float x)
{
    float a;
    //a = (pow(x,10))-1;                           //xi=0 xu= 1.3
    a = -12 - 21 * x + 18 * (pow(x, 2)) - 2.75 * (pow(x, 3)); //xi=-1 xu=0
    return a;
}

//Newton Raphson----------------------------------------------------------------

/*
    Calcula la raiz mas grande 

    f(x)= 2*x^3 -11.7*x^2 +17.7*x -5
    g(x)= 6*x^2 -23.4*x +17.7

    x0= 3
    */
float NewtonRevaluarfx(float x)
{
    /*f(x)= 2*x^3 -11.7*x^2 +17.7*x -5*/
    float a;
    a = 2 * (pow(x, 3)) - 11.7 * (pow(x, 2)) + (17.7 * x) - 5;
    return a;
}
float NewtonRevaluardx(float x)
{
    /*g(x)= 6*x^2 -23.4*x +17.7*/
    float a;
    a = 6 * (pow(x, 2)) - (23.4 * x) + 17.7;
    return a;
}

float NewtonRaphson(float x0)
{
    float evafx;
    float evadx;
    do
    {
        evafx = NewtonRevaluarfx(x0);
        evadx = NewtonRevaluardx(x0);
        //Evaluo la funcion
        xr = x0 - (evafx / evadx);
        //verifico el error
        errores();
        //cambio valor de x0 al nuevo obtenido
        x0 = xr;
        //el dato obtenido ahora es el anterior
        xrantes = xr;
    } while (ec > es);

    return xr;
}
//Secante-----------------------------------------------------------------------
/* 
    Funcion f(x) =  -0.9*x^2 +1.7*x +2.5
    xi-0=2
    xi=4
    valor esperado: 2.680104
    */
float Secanteevaluar(float x)
{
    /*Funcion f(x) =  -0.9*x^2 +1.7*x +2.5*/
    float a;
    a = -0.9 * (pow(x, 2)) + (1.7 * x) + 2.5;
    return a;
}

float Secante(float x0, float x1)
{
    float evafx0;
    float evafx1;
    do
    {
        evafx1 = Secanteevaluar(x1);
        evafx0 = Secanteevaluar(x0);
        /*Recordar
            x0= xi-1 
            x1=xi 
            */
        //Evaluo la funcion
        xr = x1 - (evafx1 * (x0 - x1)) / (evafx0 - evafx1);
        //verifico el error
        errores();
        //cambio valor de x0 al nuevo obtenido
        x0 = x1;
        x1 = xr;
        //el dato obtenido ahora es el anterior
        xrantes = xr;

    } while (ec > es);

    return xr;
}
//Biseccion-----------------------------------------------------------------------

float Biseccionevaluar(float x)
{
    /*Funcion f(x) =  (668.06/x)*(1-(pow(e,-.146843*x))) -40*/
    float a;
    a = (668.06 / x) * (1 - (pow(e, -.146843 * x))) - 40;
    return a;
}
float Biseccion(float xi, float xu)
{
    float fxi;
    float fxu;
    do
    {

        xrantes = xr;
        xr = (xi + xu) / 2;
        //evaluo la fx
        fxi = Biseccionevaluar(xi);
        fxu = Biseccionevaluar(xr);
        //errores
        errores();
        //Paso 3 evaluar comparar
        if ((fxi * fxu) < 0)
        {
            xu = xr;
        }
        else if ((fxi * fxu) > 0)
        {
            xi = xr;
        }
        else if (fxi * fxu == 0)
        {
            return xr;
        }

    } while (ec > es);

    return xr;
}

//Interpolacion de newton---------------------------------------------------------------
void IngresaArray(int ndatos, float *x)
{
    int i;
    for (i = 0; i < ndatos; i++)
    {
        terminal.printf("\nDato:(%d): ", i + 1);
        terminal.scanf("%f", &x[i]);
        terminal.printf("%f\n\r", x[i]);
    }
}

float InterpolacionNewton()
{
    //numero de datos
    //ingresando numero de datos
    terminal.printf("Numero de datos: ");
    terminal.scanf("%d", &n);
    terminal.printf("%d\n\r", n);
    float x[n], f[n];
    //ingresa los valores de x
    terminal.printf("Valores de X\r\n");
    IngresaArray(n, x);
    //ingresa los valores de y
    terminal.printf("Valores de Y \r\n");
    IngresaArray(n, f);
    //aplicamos el metodo
    int i, j;
    float sum, mult;
    sum = 0;

    for (j = 0; j < n - 1; j++)
    {
        for (i = n - 1; i > j; i--)
        {
            f[i] = (f[i] - f[i - 1]) / (x[i] - x[i - j - 1]);
        }
    }
    for (i = n - 1; i >= 0; i--)
    {
        mult = 1;
        for (j = 0; j < i; j++)
            mult *= (2.0 - x[j]);

        mult *= f[j];
        sum += mult;
    }
    return sum;
}
//lagrange----------------------------------------------------------------------------
//x[3] = {1,4,6}, f[3] = {0,1.386294,1.791759}; datos a considerara para probar
float Lagrange()
{
    //numero de datos
    //ingresando numero de datos
    terminal.printf("Numero de datos: ");
    terminal.scanf("%d", &n);
    terminal.printf("%d\n\r", n);
    float x[n], f[n];
    //ingresa los valores de x
    terminal.printf("Valores de X\r\n");
    IngresaArray(n, x);
    //ingresa los valores de y
    terminal.printf("Valores de Y \r\n");
    IngresaArray(n, f);
    //aplicamos el metodo
    int i, j;
    float sum, u, d;
    sum = 0;
    u = d = 1;

    for (i = 0; i < n; i++)
    {
        for (j = 0; j < n; j++)
        {
            if (j != i)
            {
                u = u * (2.0 - x[j]);
                d = d * (x[i] - x[j]);
            }
        }
        sum += (f[i] * (u / d));
        u = d = 1;
    }
    return sum;
}

//Gauss Jordan ------------------------------------------------------------------------
void GaussJordan()
{
    // Definicion de las dimenciones de la matriz y captura de los datos de esta
    int filas = 0, columnas = 0;

    terminal.printf("Ingresa el numero de filas: ");
    terminal.scanf("%i", &filas);
    terminal.printf("%d \n\r", filas);
    terminal.printf("\nIngresa el numero de columanas: ");
    terminal.scanf("%i", &columnas);
    terminal.printf("%d \n\r", columnas);
    columnas = columnas + 1;
    float MatrizA[filas][columnas];

    terminal.printf("Ingresa los valores de la matriz A: \r\n\n");
    for (int j = 0; j < columnas; j++)
    {
        for (int i = 0; i < filas; i++)
        {
            if (columnas - 1 == j)
            {
                terminal.printf("\nIngresa los datos del vector de resultados \r\n");
            }
            terminal.printf("Ingresa el valor de en (%i,%i): ", i + 1, j + 1);
            terminal.scanf("%f", &MatrizA[i][j]);
            terminal.printf("%f \n\r", MatrizA[i][j]);
        }
    }
    // Impresion de la matriz inicial
    terminal.printf("Matriz Inicial\r\n");
    imprimir(filas, columnas, &MatrizA[0][0]);
    terminal.printf("\n\r\n");

    //Metodo de gauss-jordan

    float vectorPivote[columnas];
    float vectorPivoteaux[columnas];
    float n = 0;

    for (int j = 0; j < columnas - 1; j++)
    {
        // Se necesita la posicion j, el vector pivote
        pivotear(filas, columnas, &MatrizA[0][0], &vectorPivote[0], &vectorPivoteaux[0], j);

        for (int i = 0; i < filas; i++)
        {
            terminal.printf("\n(%d,%d)\r\n", i + 1, j + 1);
            //Cuando i sea diferente de j se asigna el valor n, y se restringe para evitar que tome el valor de columna de resultados
            if (i != j && j < columnas - 1)
            {
                n = MatrizA[i][j];
            }

            // Opera sobre toda la fila sin importar que esta contenga ya un pivote
            for (int k = 0; k < columnas; k++)
            {
                MatrizA[i][k] = (-1 * n * vectorPivote[k]) + MatrizA[i][k];
            }

            if (i == j)
            {
                // Para evitar que se altere la fila pivote se realizan las siguientes asignaciones.
                for (int l = 0; l < columnas; l++)
                {
                    MatrizA[i][l] = vectorPivoteaux[l];
                    if (MatrizA[i][l] == -0)
                    {
                        MatrizA[i][l] = 0;
                    }
                }
            }
            imprimir(filas, columnas, &MatrizA[0][0]);
        }

        // Se limpia la fila pivote para evitar arrastrar basura al igual que n
        n = 0;
        for (int k = 0; k < columnas; k++)
        {
            vectorPivote[k] = 0;
        }
    }
}

void imprimir(int filas, int columnas, float *MatrizA)
{
    terminal.printf("\n\n\r");
    int contar = 0;

    for (int i = 0; i < filas * columnas; i++)
    {
        if (contar < columnas)
        {
            terminal.printf(" %f ", MatrizA[i]);
            contar++;
        }
        else
        {
            contar = 0;
            terminal.printf("\n\r");
            terminal.printf(" %f", MatrizA[i]);
            contar++;
        }
    }
}

void pivotear(int filas, int columnas, float *MatrizA, float *vectorPivote, float *vectorPivoteaux, int j)
{
    float pivoteaux = 0;
    float matrizTemporal[filas][columnas];
    int sumi = 0;
    //Copiamos los datos de la MatrizA  a una matriz temporal porque al enviarla como apuntador esta se convierte en un vector.

    for (int i = 0; i < filas; i++)
    {
        for (int k = 0; k < columnas; k++)
        {
            matrizTemporal[i][k] = MatrizA[sumi];
            sumi++;
        }
    }

    //Una vez copiados los datos en una matriz temporal operamos para obtener el pivote y su fila asociada

    for (int i = 0; i < filas; i++)
    {
        if (i == j)
        {
            // Suponemos que el pivote esta en la posicion (i,j) y lo calculamos dividiendo el numero en esa posicion entre si mismo.
            pivoteaux = matrizTemporal[i][j];
            terminal.printf("Pivote: %f \n\r", pivoteaux);
            // En la matriz temporal realizamos la divicion de toda la fila donde se encuentra el pivote y la guardamos en la matriz temporal y en dos vectores que usaremos mas tarde.
            for (int l = 0; l < columnas; l++)
            {
                matrizTemporal[i][l] = matrizTemporal[i][l] / pivoteaux;
                vectorPivote[l] = matrizTemporal[i][l];
                vectorPivoteaux[l] = matrizTemporal[i][l];
            }
        }
    }

    //Luego pasamos los datos de la matriz temporal a nuestra matriz de trabajo MA.
    sumi = 0;

    for (int i = 0; i < filas; i++)
    {
        for (int k = 0; k < columnas; k++)
        {
            MatrizA[sumi] = matrizTemporal[i][k];
            sumi++;
        }
    }
}

//Integracion numerica------------------------------------------------------------------------
float f(float x) //Escribir la funcion.
{
    float a = .2 + (25 * x) - (200 * (pow(x, 2))) + (675 * (pow(x, 3))) - (900 * (pow(x, 4))) + (400 * (pow(x, 5)));
    return a;
}
void IntegracionNumerica()
{
    float truevalue = 1.640533; //Valor exacto
    int n, i;
    float a, b, h, sum = 0, integral;
    terminal.printf("Escribe los limites de integracion,\n\n\r");
    terminal.printf("Limite inferior,a: ");
    terminal.scanf("%f", &a);
    terminal.printf("%f \n\r",a);
    terminal.printf("Limite superior,b: ");
    terminal.scanf("%f", &b);
    terminal.printf("%f \n\r",b);
    terminal.printf("Numero de subintervalos, n: ");
    terminal.scanf("%d", &n);
    terminal.printf("%d \n\r",n);

    float x[n + 1], y[n + 1];
    h = (b - a) / n;
    for (i = 0; i <= n; i++)
    {
        x[i] = a + i * h;
        y[i] = f(x[i]);
    }
    for (i = 1; i < n; i++)
    {
        sum = sum + h * y[i];
    }
    integral = h / 2.0 * (y[0] + y[n]) + sum;
    float errorporcentual = ((truevalue - integral) / truevalue) * 100; //calcular error porcentual
    terminal.printf("\n\nValor aproximado: ");
    terminal.printf("%f \n\r",integral);
    
    terminal.printf("Error Porcentual: ");
    terminal.printf("%f \n\r",errorporcentual);

    terminal.printf("Ancho: ");
    terminal.printf("%f \n\r",h);
}


/* END routines */ 

/* END program */ 