#include "mbed.h"
#include "QEI.h"
#include "PID.h"
/** Motorclass 
    Used to control Servo motors
*/
class Motor{
    public:
    /** Motor class declaration
    @param PWM Pin
    @param Direction Pin
    @param Encoder Pin1
    @param Encoder Pin2
    @param Homingswitch
    @param controller Interval
    */
    Motor(PinName PWM, PinName Direction, PinName Enc1,PinName Enc2,PinName HomingSW,float interval);
    
    /** GotoPos function
        This function Sends the motor to the requested Position.
        This Function needs to be called repeadedly since it also 
        triggers one tick of the PID controller
        @param The required Position in radians
    */
    void GotoPos(float Rad);
    
    /** Outputs the current motor position in radians, while keeping the gear ratio into account
    */
    float GetPos();
    
    /** Homes the motor with the homing pin
        @param Direction
        @param PWM value
        @param HomingPosition in radians
    */
    void Homing(bool direction, float PWM, float HomingPos);
    
    /** Set the Pid values
    @param Pvalue
    @param Ti
    @param Td
    */
    void SetPID(float P,float Ti,float Td);
    
    /** Set the motor gear ratio
    */
    void SetGearRatio(float GearRatio);
    
    /** Set the inputlimits, or the allowed Position
    @param InputMinimum
    @param InputMaximum
    */
    void SetInputLimits(float Imin, float Imax);
    
    /** Set the output Limits of the PWM
    @param OutputMinimum
    @param OutputMaximum
    */
    void SetOutputLimits(float Omin, float Omax);
    
    /** Stops the motor
    */
    void Stop();
    
    private:
    QEI encoder;
    float _GearRatio;
    
    PwmOut      MotorThrottle;
    DigitalOut  MotorDirection;
    DigitalIn   HomingSwitch;
    
    PID controller;
};