#include "mbed.h"
/*
Pinlayout of encoder
Pin_encoder Pin_nucleo  Color   Assesment
1           5V          white   GND
2           GND         brown   UB
3           A0          green   A+
4           -           yellow  A-
5           A1          grey    B+
6           -           pink    B-
7           A2          blue    R+
8           -           red     R-

*/
/************************
    CONNECTED PINS
************************/
InterruptIn encoderA(A0);
//InterruptIn encoderB(A1);
InterruptIn encoderR(A2);
DigitalIn encoderB_state(A1);

//Serial connection via USB.
Serial serial(SERIAL_TX, SERIAL_RX);

/************************
    GLOBAL VARIABLES
************************/
float delay = 0.02;         // 50Hz the encoder values are sent.
int pos = 0;                // Position of the encoder.
bool refference_puls = 0;   // When the refference pulse is reached, a different message is sent to the UDO NEO FULL

/************************
    FUNCTIONS
************************/
//Encoder interrupt A 
void encAInterrupt()
{
    if (encoderB_state) pos++; //myled = true; }
    else                pos--; //myled = false; }
}

//Encoder interrupt B
//This will later be implemented
void encBInterrupt()
{
    //To be implemented.
}

//Encoder refference interrupt R
void encRInterrupt()
{
    pos=0;
    refference_puls = 1;
}

/************************
    MAIN PROGRAM
************************/
int main()
{
    //Encoder interrupts
    encoderA.fall(&encAInterrupt);
    //encoderB.fall(&encBInterrupt);
    encoderR.fall(&encRInterrupt);
    
    //Serial parameters (baudrate=9600, 8-bits, no parity, 1 stopbit)
    serial.baud(9600);
    serial.format(8,Serial::None,1);
    
    while (1) {
        //When the refference puls is detected.
        if (refference_puls) {
            serial.printf("%d:",pos);   //position with ':' instead of ';' means the calibration point is met.
            refference_puls = false;
        } else {
            serial.printf("%d;",pos);
        }
        wait(delay);                    //Wait, because the UDO NEO FULL is not as fast as this board.
    }
}
