/**
@file SystemFunctions.h
@brief Header file containing functions prototypes.
@author Jordan Harper
@date   March 2017
*/

/* functions */

/** Sets signal rate for serial connection to PC and displays string of measured analog signals. 
@param pc.baud() - sets signal freq.
@param pc.printf() - prints string to PC (CoolTerm).
@returns Float values measured from each LDR. 
*/
void serialRead();

/** Records analog data from each LDR, places it in an array and gives array values weights based on how new the measurement is (organises them by significance to get accurate average signal). 
@param i - counter variable. 
@param j - counter variable. 
@param Average1 - Average value for LDR1.  
@param Average2 - Average value for LDR2.  
@param Average3 - Average value for LDR3.  
@param Average4 - Average value for LDR4.   
@returns Average value for each LDR. 
*/
void digitalFilter();

/** Moves the servo based on the signals measured from LDR's. 
@param OverallAverage - Base value of LDR signals.
@param Servo1 - signal sent to Servo 1 in analog form.
@param Servo2 - signal sent to Servo 2 in analog form.  
*/
void servoMovement();

/** Calibrates PWM signal. 
@param servo.calibrate() - sets range of movement in degrees for Pulse Width value.   
*/
void initialiseServo();

/** Automatically moves servos to test the analog signal conversion to PWM.   
*/
void positionTest();