/**
@file main.cpp

@brief Game Algorithm implementation
 */

#include "main.h"

int main()
{
    //set_time(0); // enter unix time then delete from main function to set time
    power = 1;
    lcd.init();
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/15.0);  // read joystick 15 times per second
    wallMovement.attach(&flagForWall,0.2); // call function flagForWall to make flag=1, every 0.2 seconds
    wallMovement2.attach(&flagForWall2,0.2); // call function flagForWall2 to make flag=1, every 0.2 seconds
    wallMovement3.attach(&flagForWall3,0.2); // call function flagForWall3 to make flag=1, every 0.2 seconds
    flash.attach(&flagForFlash,1); // call function flagForWall3 to make flag=1, every 1 seconds
    button.rise(&buttonFlag); // call flag when ever joystick button is pressed
    menu();
}

void calibrateJoystick()
{
    button.mode(PullDown); // must not move while calibrating
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}

void updateJoystick()
{

    joystick.x = xPot - joystick.x0; // reads current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.y = yPot - joystick.y0;
    joystick.button = button;

    /* calculate direction depending on x,y values */
    /* tolerance allows a little lee-way in case joystick not exactly in the stated direction */
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else if ( joystick.y > DIRECTION_TOLERANCE && joystick.x > DIRECTION_TOLERANCE) {
        joystick.direction = upRight;
    } else if ( joystick.y < DIRECTION_TOLERANCE && joystick.x > DIRECTION_TOLERANCE) {
        joystick.direction = downRight;
    } else if ( joystick.y > DIRECTION_TOLERANCE && joystick.x < DIRECTION_TOLERANCE) {
        joystick.direction = upLeft;
    } else if ( joystick.y < DIRECTION_TOLERANCE && joystick.x < DIRECTION_TOLERANCE) {
        joystick.direction = downLeft;
    }

    printFlag = 1; // set flag for printing
}



void clearCells()
{
    for (int i = 0; i < nx ; i++) { // loops through cells in x direction first
        for (int j = 0; j < ny ; j++) { // then moves in y direction
            lcd.clearPixel(i,j); // clears each pixel that is checked
        }
    }
    lcd.refresh(); // must refresh to write buffer display
}


void flagForWall()
{
    FLAG=1;
}


void flagForWall2()
{
    FLAG2=1;
}


void flagForWall3()
{
    FLAG3=1;
}

void buttonFlag()
{
    BFlag =1;
}

void menu()
{
    int m = 0;
    BFlag = 0;

    char buffer[14]; // buffer used to store time string

    while(1) {
        powerSave(); // call sleep function
        clearCells();
        time_t seconds = time(NULL); // gets current time
        strftime(buffer, 14 , "%H:%M", localtime(&seconds)); // send time string to buffer

        lcd.printString(buffer,26,4); // show time on lcd screen


        if ((joystick.direction == RIGHT)||(joystick.direction == upRight)||(joystick.direction == downRight)) {
            m++;
        }
        if ((joystick.direction == LEFT)||(joystick.direction == upLeft)||(joystick.direction == downLeft)) {
            m--;
        }
        if(m > 2) {
            m = 0;
        }
        if(m < 0) {
            m = 2;
        }
        switch (m) {
            case 0 :
                lcd.printString("<  Play Game >",0,2);
                wait(0.3);
                if(BFlag) {
                    BFlag=0;
                    clearCells();
                    playGame();
                }
                break;
            case 1 :
                lcd.printString("<  Settings  >",0,2);
                wait(0.3);
                if(BFlag) {
                    BFlag=0;
                    clearCells();
                    BandVMenu();
                }
                break;
            case 2 :
                lcd.printString("<  HighScore >",0,2);
                wait(0.3);
                if(BFlag) {
                    BFlag=0;
                    clearCells();
                    while(1) {
                        readDataFromFile();
                        lcd.printString("HighScore",16,0);
                        if(joystick.direction == DOWN) {
                            menu();
                        }
                    }
                }
                break;

        }
    }
}


void playGame()
{
    /* reset variables */
    i=24;
    j=42;
    x = 0;
    y = 0;
    z = 30;
    a = 0;
    b = 47;
    d = 30;
    f = 0;
    g = 0;
    h = 24;
    q = 83;
    w = 0;
    e = 24;
    score = 0;
    u = 0;

    lcd.printString("GO!",35,2);
    wait(1);
    while(1) {
        if(soundFlag==1) { // if mute hasn't been toggled in settings then the song will play
            tone();
        }
        lcd.drawRect(i,j,2,2,0); // draws player object
        clearCells();
        fallingWalls();
        boundries();
        playerMovement();

        if (lcd.getPixel(i,j)) { // if wall meets player object then there is a collision
            scoreCheck();
            int m = 1;
            GameOverFlash(); // this means that it is game over
            if (soundFlag == 1) {
                deadTone();
            }

            while(1) {
                clearCells();
                if ((joystick.direction == RIGHT)||(joystick.direction == upRight)||(joystick.direction == downRight)) { // reads joystick direction and counts down
                    m--;
                }
                if ((joystick.direction == LEFT)||(joystick.direction == upLeft)||(joystick.direction == downLeft)) { // reads joystick direction and counts up
                    m++;
                }
                if(m > 2) { // stops counter from going above total number of cases
                    m = 2;
                }
                if(m < 0) { // stops counter from going below zero
                    m = 0;
                }
                switch (m) { //switches to the case that the counter is on
                    case 0 :
                        lcd.printString("YES",0,3);
                        if(BFlag) {
                            BFlag=0;
                            clearCells();
                            playGame();
                        }
                        break;
                    case 1 :
                        lcd.printString("Play Again?",9,1);
                        lcd.printString("Yes        No",0,3);
                        wait(0.3);

                        break;
                    case 2 :
                        lcd.printString("NO",70,3);
                        if(BFlag) {
                            BFlag = 0;
                            clearCells();
                            lcd.printString("Leaving Game",0,2);
                            wait(1.0);
                            menu();
                        }
                        break;
                }
            }
        }
        if (lcd.getPixel(i+2,j)) { // same as above but for different side of player object

            scoreCheck();
            clearCells();
            int m = 1;
            GameOverFlash();
            if (soundFlag == 1) {
                deadTone();
            }

            while(1) {
                clearCells();
                if ((joystick.direction == RIGHT)||(joystick.direction == upRight)||(joystick.direction == downRight)) {
                    m--;
                }
                if ((joystick.direction == LEFT)||(joystick.direction == upLeft)||(joystick.direction == downLeft)) {
                    m++;
                }
                if(m > 2) {
                    m = 2;
                }
                if(m < 0) {
                    m = 0;
                }
                switch (m) {
                    case 0 :
                        lcd.printString("YES",0,3);
                        if(BFlag) {
                            BFlag = 0;
                            clearCells();
                            playGame();
                        }
                        break;
                    case 1 :
                        lcd.printString("Play Again?",9,1);
                        lcd.printString("Yes        No",0,3);
                        wait(0.3);

                        break;
                    case 2 :
                        lcd.printString("NO",70,3);
                        if(BFlag) {
                            BFlag = 0;
                            clearCells();
                            lcd.printString("Leaving Game",0,2);
                            wait(1.0);
                            menu();
                        }
                        break;
                }
            }
        }
        if (lcd.getPixel(i+2,j+2)) {
            scoreCheck();
            clearCells();
            int m = 1;
            GameOverFlash();
            if (soundFlag == 1) {
                deadTone();
            }

            while(1) {
                clearCells();
                if ((joystick.direction == RIGHT)||(joystick.direction == upRight)||(joystick.direction == downRight)) {
                    m--;
                }
                if ((joystick.direction == LEFT)||(joystick.direction == upLeft)||(joystick.direction == downLeft)) {
                    m++;
                }
                if(m > 2) {
                    m = 2;
                }
                if(m < 0) {
                    m = 0;
                }
                switch (m) {
                    case 0 :
                        lcd.printString("YES",0,3);
                        if(BFlag) {
                            BFlag = 0;
                            clearCells();
                            playGame();
                        }
                        break;
                    case 1 :
                        lcd.printString("Play Again?",9,1);
                        lcd.printString("Yes        No",0,3);
                        wait(0.3);

                        break;
                    case 2 :
                        lcd.printString("NO",70,3);
                        if(BFlag) {
                            BFlag = 0;
                            clearCells();
                            lcd.printString("Leaving Game",0,2);
                            wait(1.0);
                            menu();
                        }
                        break;

                }
            }
        }
        if (lcd.getPixel(i,j+2)) {
            scoreCheck();
            clearCells();
            int m = 1;
            GameOverFlash();
            if (soundFlag == 1) {
                deadTone();
            }

            while(1) {
                clearCells();
                if ((joystick.direction == RIGHT)||(joystick.direction == upRight)||(joystick.direction == downRight)) {
                    m--;
                }
                if ((joystick.direction == LEFT)||(joystick.direction == upLeft)||(joystick.direction == downLeft)) {
                    m++;
                }
                if(m > 2) {
                    m = 2;
                }
                if(m < 0) {
                    m = 0;
                }
                switch (m) {
                    case 0 :
                        lcd.printString("YES",0,3);
                        if(BFlag) {
                            BFlag = 0;
                            clearCells();
                            playGame();
                        }
                        break;
                    case 1 :
                        lcd.printString("Play Again?",9,1);
                        lcd.printString("Yes        No",0,3);
                        wait(0.3);

                        break;
                    case 2 :
                        lcd.printString("NO",70,3);
                        if(BFlag) {
                            BFlag = 0;
                            clearCells();
                            lcd.printString("Leaving Game",0,2);
                            wait(1.0);
                            menu();
                        }
                        break;

                }
            }
        }
    }
}


void BandVMenu()
{
    int t = 0;
    while(1) {
        wait(0.2);
        clearCells();
        if ((joystick.direction == RIGHT)||(joystick.direction == upRight)||(joystick.direction == downRight)) {
            t++;
        }
        if ((joystick.direction == LEFT)||(joystick.direction == upLeft)||(joystick.direction == downLeft)) {
            t--;
        }
        if(t > 2) {
            t = 0;
        }
        if(t < 0) {
            t = 2;
        }
        if(joystick.direction == DOWN) {
            clearCells();
            lcd.printString("Returning",18,2);
            lcd.printString("to Menu",24,3);
            wait(0.5);
            menu();
        }
        switch (t) {
            case 0 :
                lcd.printString("< Brightness >",0,2);
                if(BFlag) {
                    BFlag = 0;
                    brightness();
                }
                break;
            case 1 :
                lcd.printString("<   Volume   >",0,2);
                if(BFlag) {
                    BFlag = 0;
                    volume();
                }
                break;
            case 2 :
                lcd.printString("<Instructions>",0,2);
                if(BFlag) {
                    BFlag = 0;
                    instructions();
                }
                break;
        }
    }
}


void brightness()
{
    while(1) {
        wait(0.2);
        clearCells();
        if ((joystick.direction == RIGHT)||(joystick.direction == upRight)||(joystick.direction == downRight)) {
            bright--;
        }
        if ((joystick.direction == LEFT)||(joystick.direction == upLeft)||(joystick.direction == downLeft)) {
            bright++;
        }
        if(bright > 3) {
            bright = 3;
        }
        if(bright < -3) {
            bright = -3;
        }
        switch (bright) {
            case 0 :
                lcd.printString("  Brightness ",0,2);
                lcd.printString(" ||||||",0,4);
                lcd.setBrightness(0.6);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case 1 :
                lcd.printString("  Brightness ",0,2);
                lcd.printString(" ||||||||",0,4);
                lcd.setBrightness(0.8);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case 2 :
                lcd.printString("  Brightness ",0,2);
                lcd.printString(" ||||||||||",0,4);
                lcd.setBrightness(0.9);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case 3 :
                lcd.printString("  Brightness ",0,2);
                lcd.printString(" ||||||||||||",0,4);
                lcd.setBrightness(1);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case -1 :
                lcd.printString("  Brightness ",0,2);
                lcd.printString(" ||||",0,4);
                lcd.setBrightness(0.4);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case -2 :
                lcd.printString("  Brightness ",0,2);
                lcd.printString(" ||",0,4);
                lcd.setBrightness(0.2);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case -3 :
                lcd.printString("  Brightness ",0,2);
                lcd.setBrightness(0);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
        }
    }
}


void volume()
{
    while(1) {
        wait(0.2);
        clearCells();
        if ((joystick.direction == RIGHT)||(joystick.direction == upRight)||(joystick.direction == downRight)) {
            vol--;
        }
        if ((joystick.direction == LEFT)||(joystick.direction == upLeft)||(joystick.direction == downLeft)) {
            vol++;
        }
        if(vol > 3) {
            vol = 3;
        }
        if(vol < -3) {
            vol = -3;
        }
        switch (vol) {
            case 0 :
                lcd.printString("    Volume   ",0,2);
                lcd.printString(" ||||||",0,4);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case 1 :
                lcd.printString("    Volume   ",0,2);
                lcd.printString(" ||||||||",0,4);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case 2 :
                lcd.printString("    Volume   ",0,2);
                lcd.printString(" ||||||||||",0,4);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case 3 :
                lcd.printString("    Volume   ",0,2);
                lcd.printString(" ||||||||||||",0,4);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case -1 :
                lcd.printString("    Volume   ",0,2);
                lcd.printString(" ||||",0,4);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case -2 :
                lcd.printString("    Volume   ",0,2);
                lcd.printString(" ||",0,4);
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
            case -3 :
                lcd.printString("    Volume    ",0,2);
                lcd.printString(" MUTE",0,4);
                soundFlag = 0;
                if(BFlag) {
                    BFlag = 0;
                    BandVMenu();
                }
                break;
        }
    }
}


void writeDataToFile()
{
    time_t seconds = time(NULL); // get current time
    char buffer2[14]; // buffer used to store time string
    strftime(buffer2, 14, " %d/%m/%y", localtime(&seconds)); // displays unix time in day/ month/ year format and sends it to buffer

    FILE *fp = fopen("/local/score.txt", "w"); // open file called 'score.txt'
    /* if the file doesn't exist it is created, if it exists, data is updated */
    fprintf(fp,"%i%s",score,buffer2); // print integer for score and date to file
    fclose(fp); // close file
}


void readDataFromFile()
{
    int score1; // states the score to be read from the file is an integer value
    char buffer2recieved[14]; // buffer to recieve the string of data read from the text file

    FILE *fp2 = fopen("/local/score.txt", "r"); // open 'score.txt'
    fscanf (fp2,"%i%s",&score1,buffer2recieved); // scans text file for an integer followed by a string
    fclose(fp2); // close file

    char Points[14]; // buffer to store score value
    sprintf(Points,"%i",score1); // send score to buffer (Points)
    lcd.printString(Points,39,2); // print score on LCD
    lcd.printString(buffer2recieved,18,4); // print date on LCD

}



void tone()
{

    if(FLAG3==1) {
        FLAG3 = 0;
        buz.period(1/(frequency[u])); // set PWM period
        buz=0.2;
        u++;
    }
    if( u > 30) {
        u = 0;
    }

}


void deadTone()
{
    int l = 0;
    while(1) {
        if(FLAG3==1) {
            FLAG3 = 0;
            buz.period(1/(frequency2[l])); // set PWM period
            buz=0.2;
            l++;
        }
        if( l > 6) {
            break;
        }
    }
}


void scoreCheck()
{
    int score1;

    FILE *fp2 = fopen("/local/score.txt", "r");
    fscanf (fp2,"%i",&score1);
    fclose(fp2);

    if(score1 < score) {
        writeDataToFile(); // if the score is bigger then the data is written to the file and overwrites the previous data
    }
}


void flagForFlash()
{
    flashFlag = 1;
}


void GameOverFlash()
{
    int flash = 0;
    while(1) {
        if (flashFlag==1) { // flag equals one every second
            flashFlag = 0; // flag is reset
            lcd.printString("Game Over!",12,2); // print phrase
            flash++; // adds one to counter
        }
        if (flash > 3) { // moves onto next function when counter gets to 3
            break;
        }
    }
}


void powerSave()
{
    if(joystick.direction == CENTRE) {
        if (flashFlag==1) {
            flashFlag = 0;
            sleepCounter++;
        }
        if(sleepCounter > 20) {
            Sleep(); // put mbed into sleep mode
            lcd.turnOff(); // turn LCD off
            while(1){
            if(BFlag) {
                BFlag = 0;
                lcd.init(); // turn LCD back on
                sleepCounter = 0;
                wait(0.5);
                menu();
            }
            }
        }

    } else {
        sleepCounter = 0;
    }
}


void boundries()
{
    if( j > 45) {
        j = 45;
    }
    if( i > 81) {
        i = 81;
    }
    if( j < 0) {
        j = 0;
    }
    if( i < 0) {
        i = 0;
    }
}


void playerMovement()
{

    if (printFlag) {  // if flag set, clear flag and implicate joystick functions
        printFlag = 0;
        /* check joystick direction */
        if (joystick.direction == UP) {
            j--;
        }
        if (joystick.direction == DOWN) {
            j++;
        }
        if (joystick.direction == LEFT) {
            i++;
        }
        if (joystick.direction == RIGHT) {
            i--;
        }
        if (joystick.direction == upRight) {
            j--;
            i--;
        }
        if (joystick.direction == downRight) {
            j++;
            i--;
        }
        if (joystick.direction == upLeft) {
            j--;
            i++;
        }
        if (joystick.direction == downLeft) {
            j++;
            i++;
        }
        if (joystick.direction == CENTRE) {
            i=i;
            j=j;
        }
    }
}


void fallingWalls()
{
    lcd.drawLine(x,y,z,y,1); // draws a line at the top of the screen to symbolise a wall
    lcd.drawLine(z+10,y,83,y,1); // there is a gap in the wall which is 10 pixels wide and the objective of the game is to pass through it
    if(FLAG==1) { // the flag changes every 0.2 seconds
        FLAG=0;
        y++;  // everytime the flag changes to one it is reset and the wall moves down by one pixel
    }
    if(y > 47) { // when the wall reaches the bottom a new wall is generated at the top
        y = 0;
        z = rand()%74; // the gap in the is moved to a random postion in the new wall
        score++; // score increases by one everytime a wall falling from the top reaches the bottom of the screen
    }
    /* there are 6 levels of difficulty */
    if(( score > 1)&&(score < 5)) {
        lcd.drawLine(a,b,d,b,1);
        lcd.drawLine(d+10,b,83,b,1);
        if(FLAG3==1) {
            FLAG3=0;
            b--;
        }
    }
    if(b < 0) {
        b = 47;
        d = rand()%74;
    }
    if(( score > 5)&&(score < 9)) {
        lcd.drawLine(f,g,f,h,1);
        lcd.drawLine(f,h+10,f,47,1);
        if(FLAG2==1) {
            FLAG2=0;
            f++;
        }
    }
    if( f > 83) {
        f = 0;
        h = rand()%38;
    }
    if(( score > 10)&&(score < 15)) {
        lcd.drawLine(q,w,q,e,1);
        lcd.drawLine(q,e+10,q,47,1);
        if(FLAG3==1) {
            FLAG3=0;
            q--;
        }
    }
    if(q < 0) {
        q = 83;
        e = rand()%38;
    }
    if( score > 15) {
        lcd.drawLine(q,w,q,e,1);
        lcd.drawLine(q,e+10,q,47,1);
        if(FLAG3==1) {
            FLAG3=0;
            q--;
        }
    }
    if( score > 20) {
        lcd.drawLine(a,b,d,b,1);
        lcd.drawLine(d+10,b,83,b,1);
        if(FLAG2==1) {
            FLAG2=0;
            b--;
        }
    }
}

void instructions()
{
    while(1) {
        lcd.printString("Welcome :-)",9,0);
        lcd.printString("Select using",6,1);
        lcd.printString("joystickButton",0,2);
        lcd.printString("Press >",27,4);
        wait(0.5);
        if(BFlag) {
            BFlag = 0; // press joystick button to continue
            clearCells();
            while(1) {
                lcd.printString("Return to menu",0,0);
                lcd.printString("by moving the",3,1);
                lcd.printString("JS downward",9,2);
                if(joystick.direction == DOWN) { // direct joystick down to continue
                    menu();
                    break;
                }
            }
        }
    }
}